/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.endpoint;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.kafka.endpoint.KafkaEndpoint;
import com.consol.citrus.kafka.message.KafkaMessageConverter;
import com.consol.citrus.kafka.message.KafkaMessageHeaderMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaEndpointBuilder
extends AbstractEndpointBuilder<KafkaEndpoint> {
    private KafkaEndpoint endpoint = new KafkaEndpoint();

    protected KafkaEndpoint getEndpoint() {
        return this.endpoint;
    }

    public KafkaEndpointBuilder server(String server) {
        this.endpoint.getEndpointConfiguration().setServer(server);
        return this;
    }

    public KafkaEndpointBuilder topic(String topicName) {
        this.endpoint.getEndpointConfiguration().setTopic(topicName);
        return this;
    }

    public KafkaEndpointBuilder partition(int partition) {
        this.endpoint.getEndpointConfiguration().setPartition(partition);
        return this;
    }

    public KafkaEndpointBuilder autoCommit(boolean autoCommit) {
        this.endpoint.getEndpointConfiguration().setAutoCommit(autoCommit);
        return this;
    }

    public KafkaEndpointBuilder autoCommitInterval(int autoCommitInterval) {
        this.endpoint.getEndpointConfiguration().setAutoCommitInterval(autoCommitInterval);
        return this;
    }

    public KafkaEndpointBuilder offsetReset(String offsetReset) {
        this.endpoint.getEndpointConfiguration().setOffsetReset(offsetReset);
        return this;
    }

    public KafkaEndpointBuilder clientId(String clientId) {
        this.endpoint.getEndpointConfiguration().setClientId(clientId);
        return this;
    }

    public KafkaEndpointBuilder consumerGroup(String group) {
        this.endpoint.getEndpointConfiguration().setConsumerGroup(group);
        return this;
    }

    public KafkaEndpointBuilder messageConverter(KafkaMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public KafkaEndpointBuilder headerMapper(KafkaMessageHeaderMapper headerMapper) {
        this.endpoint.getEndpointConfiguration().setHeaderMapper(headerMapper);
        return this;
    }

    public KafkaEndpointBuilder keySerializer(Class<? extends Serializer> serializer) {
        this.endpoint.getEndpointConfiguration().setKeySerializer(serializer);
        return this;
    }

    public KafkaEndpointBuilder valueSerializer(Class<? extends Serializer> serializer) {
        this.endpoint.getEndpointConfiguration().setValueSerializer(serializer);
        return this;
    }

    public KafkaEndpointBuilder keyDeserializer(Class<? extends Deserializer> deserializer) {
        this.endpoint.getEndpointConfiguration().setKeyDeserializer(deserializer);
        return this;
    }

    public KafkaEndpointBuilder valueDeserializer(Class<? extends Deserializer> deserializer) {
        this.endpoint.getEndpointConfiguration().setValueDeserializer(deserializer);
        return this;
    }

    public KafkaEndpointBuilder producerProperties(Map<String, Object> producerProperties) {
        this.endpoint.getEndpointConfiguration().setProducerProperties(producerProperties);
        return this;
    }

    public KafkaEndpointBuilder consumerProperties(Map<String, Object> consumerProperties) {
        this.endpoint.getEndpointConfiguration().setConsumerProperties(consumerProperties);
        return this;
    }

    public KafkaEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

