/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.message;

import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.util.TypeConversionUtils;
import java.util.Map;

public class KafkaMessage
extends DefaultMessage {
    public KafkaMessage() {
    }

    public KafkaMessage(Object payload, Map<String, Object> headers) {
        super(payload, headers);
    }

    public KafkaMessage(Object payload) {
        super(payload);
    }

    public KafkaMessage partition(int partition) {
        this.setHeader("citrus_kafka_partition", partition);
        return this;
    }

    public KafkaMessage timestamp(Long timestamp) {
        this.setHeader("citrus_kafka_timestamp", timestamp);
        return this;
    }

    public KafkaMessage offset(long offset) {
        this.setHeader("citrus_kafka_offset", offset);
        return this;
    }

    public KafkaMessage messageKey(Object key) {
        this.setHeader("citrus_kafka_messageKey", key);
        return this;
    }

    public KafkaMessage topic(String topic) {
        this.setHeader("citrus_kafka_topic", topic);
        return this;
    }

    public Integer getPartition() {
        Object partition = this.getHeader("citrus_kafka_partition");
        if (partition != null) {
            return (Integer)TypeConversionUtils.convertIfNecessary((Object)partition, Integer.class);
        }
        return null;
    }

    public Long getTimestamp() {
        Object timestamp = this.getHeader("citrus_kafka_timestamp");
        if (timestamp != null) {
            return Long.valueOf(timestamp.toString());
        }
        return null;
    }

    public Long getOffset() {
        Object offset = this.getHeader("citrus_kafka_offset");
        if (offset != null) {
            return (Long)TypeConversionUtils.convertIfNecessary((Object)offset, Long.class);
        }
        return 0L;
    }

    public Object getMessageKey() {
        Object key = this.getHeader("citrus_kafka_messageKey");
        if (key != null) {
            return key;
        }
        return null;
    }

    public String getTopic() {
        Object topic = this.getHeader("citrus_kafka_topic");
        if (topic != null) {
            return topic.toString();
        }
        return null;
    }
}

