/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.embedded;

import com.consol.citrus.kafka.embedded.EmbeddedKafkaServer;
import com.consol.citrus.kafka.embedded.EmbeddedKafkaServerBuilder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@PropertySource(value={"classpath:${citrus.kafka.server.properties.file:citrus-kafka-server.properties}"}, ignoreResourceNotFound=true)
public class EmbeddedKafkaServerApp {
    @Value(value="${citrus.kafka.server.topics:default.topic}")
    private String topics;
    @Value(value="${citrus.kafka.server.port:9092}")
    private int port;

    @Bean
    public EmbeddedKafkaServer kafkaServer() {
        return new EmbeddedKafkaServerBuilder().kafkaServerPort(this.port).topics(this.topics).build();
    }

    public static void main(String[] args) {
        new AnnotationConfigApplicationContext(new Class[]{EmbeddedKafkaServerApp.class}).start();
    }
}

