/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.mail.client.MailClient;
import com.consol.citrus.mail.client.MailClientBuilder;
import com.consol.citrus.mail.config.annotation.MailClientConfig;
import com.consol.citrus.mail.message.MailMessageConverter;
import com.consol.citrus.mail.model.MailMarshaller;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class MailClientConfigParser
extends AbstractAnnotationConfigParser<MailClientConfig, MailClient> {
    public MailClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public MailClient parse(MailClientConfig annotation) {
        MailClientBuilder builder = new MailClientBuilder();
        builder.host(annotation.host());
        builder.port(annotation.port());
        builder.protocol(annotation.protocol());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.javaMailProperties())) {
            builder.javaMailProperties((Properties)this.getReferenceResolver().resolve(annotation.javaMailProperties(), Properties.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((MailMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), MailMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.marshaller())) {
            builder.marshaller((MailMarshaller)((Object)this.getReferenceResolver().resolve(annotation.marshaller(), MailMarshaller.class)));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (MailClient)builder.initialize().build();
    }
}

