/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.server;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.client.MailEndpointConfiguration;
import com.consol.citrus.mail.message.MailMessage;
import com.consol.citrus.mail.message.MailMessageConverter;
import com.consol.citrus.mail.model.AcceptResponse;
import com.consol.citrus.mail.model.AttachmentPart;
import com.consol.citrus.mail.model.BodyPart;
import com.consol.citrus.mail.model.MailMarshaller;
import com.consol.citrus.mail.model.MailRequest;
import com.consol.citrus.mail.model.MailResponse;
import com.consol.citrus.message.Message;
import com.consol.citrus.server.AbstractServer;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.xml.transform.Source;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.mail.javamail.MimeMailMessage;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListenerAdapter;
import org.subethamail.smtp.server.SMTPServer;

public class MailServer
extends AbstractServer
implements SimpleMessageListener,
InitializingBean {
    private int port = 25;
    private MailMarshaller marshaller = new MailMarshaller();
    private MailMessageConverter messageConverter = new MailMessageConverter();
    private Session mailSession;
    private Properties javaMailProperties = new Properties();
    private boolean autoAccept = true;
    private boolean splitMultipart = false;
    private SMTPServer smtpServer;

    protected void startup() {
        this.smtpServer = new SMTPServer((MessageHandlerFactory)new SimpleMessageListenerAdapter((SimpleMessageListener)this));
        this.smtpServer.setSoftwareName(this.getName());
        this.smtpServer.setPort(this.port);
        this.smtpServer.start();
    }

    protected void shutdown() {
        this.smtpServer.stop();
    }

    public boolean accept(String from, String recipient) {
        if (this.autoAccept) {
            return true;
        }
        Message response = this.getEndpointAdapter().handleMessage((Message)MailMessage.accept(from, recipient).marshaller(this.marshaller));
        if (response == null || response.getPayload() == null) {
            throw new CitrusRuntimeException("Did not receive accept response. Missing accept response because autoAccept is disabled.");
        }
        AcceptResponse acceptResponse = null;
        if (response.getPayload() instanceof AcceptResponse) {
            acceptResponse = (AcceptResponse)response.getPayload();
        } else if (response.getPayload() instanceof String) {
            acceptResponse = (AcceptResponse)this.marshaller.unmarshal((Source)response.getPayload(Source.class));
        }
        if (acceptResponse == null) {
            throw new CitrusRuntimeException("Unable to read accept response from payload: " + response);
        }
        return acceptResponse.isAccept();
    }

    public void deliver(String from, String recipient, InputStream data) {
        try {
            MimeMailMessage mimeMailMessage = new MimeMailMessage(new MimeMessage(this.getSession(), data));
            MailMessage request = this.messageConverter.convertInbound(mimeMailMessage, this.getEndpointConfiguration(), null);
            Message response = this.invokeEndpointAdapter(request);
            if (response != null && response.getPayload() != null) {
                MailResponse mailResponse = null;
                if (response.getPayload() instanceof MailResponse) {
                    mailResponse = (MailResponse)response.getPayload();
                } else if (response.getPayload() instanceof String) {
                    mailResponse = (MailResponse)this.marshaller.unmarshal((Source)response.getPayload(Source.class));
                }
                if (mailResponse != null && mailResponse.getCode() != 250) {
                    throw new RejectException(mailResponse.getCode(), mailResponse.getMessage());
                }
            }
        }
        catch (MessagingException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
    }

    protected Message invokeEndpointAdapter(MailMessage mail) {
        if (this.splitMultipart) {
            return this.split(mail.getPayload(MailRequest.class).getBody(), mail.getHeaders());
        }
        return this.getEndpointAdapter().handleMessage((Message)mail);
    }

    private Message split(BodyPart bodyPart, Map<String, Object> messageHeaders) {
        MailMessage mailRequest = this.createMailMessage(messageHeaders, bodyPart.getContent(), bodyPart.getContentType());
        Stack<Message> responseStack = new Stack<Message>();
        if (bodyPart instanceof AttachmentPart) {
            this.fillStack(this.getEndpointAdapter().handleMessage((Message)mailRequest.setHeader("citrus_mail_content_type", bodyPart.getContentType()).setHeader("citrus_mail_filename", (Object)((AttachmentPart)bodyPart).getFileName())), responseStack);
        } else {
            this.fillStack(this.getEndpointAdapter().handleMessage((Message)mailRequest.setHeader("citrus_mail_content_type", bodyPart.getContentType())), responseStack);
        }
        if (bodyPart.hasAttachments()) {
            for (AttachmentPart attachmentPart : bodyPart.getAttachments().getAttachments()) {
                this.fillStack(this.split(attachmentPart, messageHeaders), responseStack);
            }
        }
        return responseStack.isEmpty() ? null : responseStack.pop();
    }

    private void fillStack(Message message, Stack<Message> responseStack) {
        if (message != null) {
            responseStack.push(message);
        }
    }

    protected MailMessage createMailMessage(Map<String, Object> messageHeaders, String body, String contentType) {
        return MailMessage.request(messageHeaders).marshaller(this.marshaller).from(messageHeaders.get("citrus_mail_from").toString()).to(messageHeaders.get("citrus_mail_to").toString()).cc(messageHeaders.get("citrus_mail_cc").toString()).bcc(messageHeaders.get("citrus_mail_bcc").toString()).subject(messageHeaders.get("citrus_mail_subject").toString()).body(body, contentType);
    }

    public MailEndpointConfiguration getEndpointConfiguration() {
        MailEndpointConfiguration endpointConfiguration = new MailEndpointConfiguration();
        endpointConfiguration.setMessageConverter(this.messageConverter);
        endpointConfiguration.setMarshaller(this.marshaller);
        endpointConfiguration.setJavaMailProperties(this.javaMailProperties);
        return endpointConfiguration;
    }

    public synchronized Session getSession() {
        if (this.mailSession == null) {
            this.mailSession = Session.getInstance((Properties)this.javaMailProperties);
        }
        return this.mailSession;
    }

    public boolean isAutoAccept() {
        return this.autoAccept;
    }

    public void setAutoAccept(boolean autoAccept) {
        this.autoAccept = autoAccept;
    }

    public MailMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(MailMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Properties getJavaMailProperties() {
        return this.javaMailProperties;
    }

    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SMTPServer getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(SMTPServer smtpServer) {
        this.smtpServer = smtpServer;
    }

    public boolean isSplitMultipart() {
        return this.splitMultipart;
    }

    public void setSplitMultipart(boolean splitMultipart) {
        this.splitMultipart = splitMultipart;
    }

    public MailMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(MailMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }
}

