/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.model;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.model.AcceptRequest;
import com.consol.citrus.mail.model.AcceptResponse;
import com.consol.citrus.mail.model.MailRequest;
import com.consol.citrus.mail.model.MailResponse;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.xml.StringResult;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class MailMarshaller
extends ObjectMapper
implements Marshaller,
Unmarshaller {
    private static final String MAIL_MARSHALLER_TYPE_PROPERTY = "citrus.mail.marshaller.type";
    private Jaxb2Marshaller jaxbDelegate = new Jaxb2Marshaller();
    private String type = MessageType.XML.name();
    private static Logger log = LoggerFactory.getLogger(MailMarshaller.class);

    public MailMarshaller() {
        this.jaxbDelegate.setClassesToBeBound(new Class[]{MailRequest.class, MailResponse.class, AcceptRequest.class, AcceptResponse.class});
        this.jaxbDelegate.setSchema((Resource)new ClassPathResource("com/consol/citrus/schema/citrus-mail-message.xsd"));
        this.type = System.getProperty(MAIL_MARSHALLER_TYPE_PROPERTY, this.type);
        try {
            this.jaxbDelegate.afterPropertiesSet();
        }
        catch (Exception e) {
            log.warn("Failed to setup mail message marshaller", (Throwable)e);
        }
    }

    public boolean supports(Class<?> clazz) {
        return this.jaxbDelegate.supports(clazz);
    }

    public Object unmarshal(Source source) {
        if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                return this.jaxbDelegate.unmarshal(source);
            }
            catch (XmlMappingException e) {
                if (source instanceof StreamSource) {
                    for (Class type : Arrays.asList(AcceptRequest.class, AcceptResponse.class, MailRequest.class, MailResponse.class)) {
                        try {
                            return this.readValue(((StreamSource)source).getReader(), type);
                        }
                        catch (JsonParseException | JsonMappingException e2) {
                        }
                        catch (IOException io) {
                            log.warn("Unable to read mail JSON object from source", (Throwable)io);
                            throw e;
                        }
                    }
                }
                throw e;
            }
        }
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            for (Class type : Arrays.asList(AcceptRequest.class, AcceptResponse.class, MailRequest.class, MailResponse.class)) {
                try {
                    return this.readValue(((StreamSource)source).getReader(), type);
                }
                catch (JsonParseException | JsonMappingException e2) {
                }
                catch (IOException io) {
                    throw new CitrusRuntimeException("Unable to read mail JSON object from source", (Throwable)io);
                }
            }
            throw new CitrusRuntimeException("Failed to read mail JSON object from source:" + source);
        }
        throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
    }

    public void marshal(Object graph, Result result) {
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            if (result instanceof StringResult) {
                StringWriter writer = new StringWriter();
                ((StringResult)result).setWriter((Writer)writer);
                try {
                    this.writer().writeValue((Writer)writer, graph);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to write mail object graph to result", (Throwable)e);
                }
            }
        } else if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            this.jaxbDelegate.marshal(graph, result);
        } else {
            throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

