/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.client;

import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.client.MailEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.Producer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.util.StringUtils;

public class MailClient
extends AbstractEndpoint
implements Producer,
InitializingPhase {
    private static Logger log = LoggerFactory.getLogger(MailClient.class);

    public MailClient() {
        super((EndpointConfiguration)new MailEndpointConfiguration());
    }

    public MailClient(MailEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public MailEndpointConfiguration getEndpointConfiguration() {
        return (MailEndpointConfiguration)super.getEndpointConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message, TestContext context) {
        Message mailMessage;
        if (log.isDebugEnabled()) {
            log.debug(String.format("Sending mail message to host: '%s://%s:%s'", this.getEndpointConfiguration().getProtocol(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
        }
        MimeMailMessage mimeMessage = this.getEndpointConfiguration().getMessageConverter().convertOutbound(message, this.getEndpointConfiguration(), context);
        this.getEndpointConfiguration().getJavaMailSender().send(mimeMessage.getMimeMessage());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            mimeMessage.getMimeMessage().writeTo((OutputStream)bos);
            mailMessage = new RawMessage(bos.toString());
        }
        catch (IOException e) {
            mailMessage = message;
        }
        catch (MessagingException e) {
            mailMessage = message;
        }
        finally {
            try {
                bos.close();
            }
            catch (IOException e) {
                log.warn("Failed to close output stream", (Throwable)e);
            }
        }
        context.onOutboundMessage(mailMessage);
        log.info(String.format("Mail message was sent to host: '%s://%s:%s'", this.getEndpointConfiguration().getProtocol(), this.getEndpointConfiguration().getHost(), this.getEndpointConfiguration().getPort()));
    }

    public Producer createProducer() {
        return this;
    }

    public Consumer createConsumer() {
        throw new CitrusRuntimeException("Mail client is unable to create message consumer!");
    }

    public void initialize() {
        if (StringUtils.hasText((String)this.getEndpointConfiguration().getJavaMailSender().getUsername()) || StringUtils.hasText((String)this.getEndpointConfiguration().getJavaMailSender().getPassword())) {
            Properties javaMailProperties = this.getEndpointConfiguration().getJavaMailSender().getJavaMailProperties();
            javaMailProperties.setProperty("mail.smtp.auth", "true");
            this.getEndpointConfiguration().getJavaMailSender().setJavaMailProperties(javaMailProperties);
        }
        if (!StringUtils.hasText((String)this.getEndpointConfiguration().getJavaMailSender().getProtocol())) {
            this.getEndpointConfiguration().getJavaMailSender().setProtocol("smtp");
        }
    }
}

