/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.mail.client.MailClient;
import com.consol.citrus.mail.client.MailClientBuilder;
import com.consol.citrus.mail.config.annotation.MailClientConfig;
import com.consol.citrus.mail.message.MailMessageConverter;
import com.consol.citrus.mail.model.MailMarshaller;
import com.consol.citrus.spi.ReferenceResolver;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class MailClientConfigParser
implements AnnotationConfigParser<MailClientConfig, MailClient> {
    public MailClient parse(MailClientConfig annotation, ReferenceResolver referenceResolver) {
        MailClientBuilder builder = new MailClientBuilder();
        builder.host(annotation.host());
        builder.port(annotation.port());
        builder.protocol(annotation.protocol());
        if (StringUtils.hasText((String)annotation.username())) {
            builder.username(annotation.username());
        }
        if (StringUtils.hasText((String)annotation.password())) {
            builder.password(annotation.password());
        }
        if (StringUtils.hasText((String)annotation.javaMailProperties())) {
            builder.javaMailProperties((Properties)referenceResolver.resolve(annotation.javaMailProperties(), Properties.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((MailMessageConverter)referenceResolver.resolve(annotation.messageConverter(), MailMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.marshaller())) {
            builder.marshaller((MailMarshaller)((Object)referenceResolver.resolve(annotation.marshaller(), MailMarshaller.class)));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (MailClient)builder.initialize().build();
    }
}

