/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.model.AcceptRequest;
import com.consol.citrus.mail.model.AcceptResponse;
import com.consol.citrus.mail.model.BodyPart;
import com.consol.citrus.mail.model.MailMarshaller;
import com.consol.citrus.mail.model.MailRequest;
import com.consol.citrus.mail.model.MailResponse;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.xml.StringResult;
import java.util.Map;
import javax.xml.transform.Result;

public class MailMessage
extends DefaultMessage {
    private MailMarshaller marshaller = new MailMarshaller();
    private MailRequest mailRequest;
    private MailResponse mailResponse;
    private AcceptRequest acceptRequest;
    private AcceptResponse acceptResponse;

    private MailMessage() {
    }

    private MailMessage(MailRequest mailRequest) {
        super((Object)mailRequest);
        this.mailRequest = mailRequest;
    }

    private MailMessage(MailResponse mailResponse) {
        super((Object)mailResponse);
        this.mailResponse = mailResponse;
    }

    private MailMessage(AcceptRequest acceptRequest) {
        super((Object)acceptRequest);
        this.acceptRequest = acceptRequest;
    }

    private MailMessage(AcceptResponse acceptResponse) {
        super((Object)acceptResponse);
        this.acceptResponse = acceptResponse;
    }

    private MailMessage(MailRequest mailRequest, Map<String, Object> headers) {
        super((Object)mailRequest, headers);
        this.mailRequest = mailRequest;
    }

    public static MailMessage request(Map<String, Object> headers) {
        MailRequest request = new MailRequest();
        if (headers.containsKey("citrus_mail_from")) {
            request.setFrom(headers.get("citrus_mail_from").toString());
        }
        if (headers.containsKey("citrus_mail_to")) {
            request.setTo(headers.get("citrus_mail_to").toString());
        }
        if (headers.containsKey("citrus_mail_cc")) {
            request.setCc(headers.get("citrus_mail_cc").toString());
        }
        if (headers.containsKey("citrus_mail_bcc")) {
            request.setBcc(headers.get("citrus_mail_bcc").toString());
        }
        if (headers.containsKey("citrus_mail_subject")) {
            request.setSubject(headers.get("citrus_mail_subject").toString());
        }
        return new MailMessage(request, headers);
    }

    public static MailMessage request() {
        return MailMessage.request(null, null, null);
    }

    public static MailMessage request(String from) {
        return MailMessage.request(from, null, null);
    }

    public static MailMessage request(String from, String to) {
        return MailMessage.request(from, to, null);
    }

    public static MailMessage request(String from, String to, String subject) {
        MailRequest request = new MailRequest();
        request.setFrom(from);
        request.setTo(to);
        request.setSubject(subject);
        return new MailMessage(request);
    }

    public static MailMessage response() {
        return MailMessage.response(250);
    }

    public static MailMessage response(int code) {
        return MailMessage.response(code, "OK");
    }

    public static MailMessage response(int code, String message) {
        MailResponse response = new MailResponse();
        response.setCode(code);
        response.setMessage(message);
        return new MailMessage(response);
    }

    public static MailMessage accept(String from, String to) {
        AcceptRequest accept = new AcceptRequest();
        accept.setFrom(from);
        accept.setTo(to);
        return new MailMessage(accept);
    }

    public static MailMessage accept() {
        return MailMessage.accept(true);
    }

    public static MailMessage accept(boolean result) {
        AcceptResponse acceptResponse = new AcceptResponse();
        acceptResponse.setAccept(result);
        return new MailMessage(acceptResponse);
    }

    public MailMessage subject(String subject) {
        if (this.mailRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'subject' for mail message");
        }
        this.mailRequest.setSubject(subject);
        return this;
    }

    public MailMessage from(String from) {
        if (this.mailRequest == null && this.acceptRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'from' for mail message");
        }
        if (this.mailRequest != null) {
            this.mailRequest.setFrom(from);
        }
        if (this.acceptRequest != null) {
            this.acceptRequest.setFrom(from);
        }
        return this;
    }

    public MailMessage to(String to) {
        if (this.mailRequest == null && this.acceptRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'to' for mail message");
        }
        if (this.mailRequest != null) {
            this.mailRequest.setTo(to);
        }
        if (this.acceptRequest != null) {
            this.acceptRequest.setTo(to);
        }
        return this;
    }

    public MailMessage cc(String cc) {
        if (this.mailRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'cc' for mail message");
        }
        this.mailRequest.setCc(cc);
        return this;
    }

    public MailMessage bcc(String bcc) {
        if (this.mailRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'bcc' for mail message");
        }
        this.mailRequest.setBcc(bcc);
        return this;
    }

    public MailMessage body(BodyPart bodyPart) {
        if (this.mailRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'subject' for mail message");
        }
        this.mailRequest.setBody(bodyPart);
        return this;
    }

    public MailMessage body(String body) {
        return this.body(body, "text/plain");
    }

    public MailMessage body(String body, String contentType) {
        if (this.mailRequest == null) {
            throw new CitrusRuntimeException("Invalid access to method 'subject' for mail message");
        }
        this.mailRequest.setBody(new BodyPart(body, contentType));
        return this;
    }

    public MailMessage marshaller(MailMarshaller mailMarshaller) {
        this.marshaller = mailMarshaller;
        return this;
    }

    public <T> T getPayload(Class<T> type) {
        if (String.class.equals(type)) {
            return (T)this.getPayload();
        }
        if (MailRequest.class.equals(type) && this.mailRequest != null) {
            return (T)this.mailRequest;
        }
        if (MailResponse.class.equals(type) && this.mailResponse != null) {
            return (T)this.mailResponse;
        }
        if (AcceptRequest.class.equals(type) && this.acceptRequest != null) {
            return (T)this.acceptRequest;
        }
        if (AcceptResponse.class.equals(type) && this.acceptResponse != null) {
            return (T)this.acceptResponse;
        }
        return (T)super.getPayload(type);
    }

    public Object getPayload() {
        StringResult payloadResult = new StringResult();
        if (this.mailRequest != null) {
            this.marshaller.marshal(this.mailRequest, (Result)payloadResult);
            return payloadResult.toString();
        }
        if (this.mailResponse != null) {
            this.marshaller.marshal(this.mailResponse, (Result)payloadResult);
            return payloadResult.toString();
        }
        if (this.acceptRequest != null) {
            this.marshaller.marshal(this.acceptRequest, (Result)payloadResult);
            return payloadResult.toString();
        }
        if (this.acceptResponse != null) {
            this.marshaller.marshal(this.acceptResponse, (Result)payloadResult);
            return payloadResult.toString();
        }
        return super.getPayload();
    }

    public MailMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(MailMarshaller marshaller) {
        this.marshaller = marshaller;
    }
}

