/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.message;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.client.MailEndpointConfiguration;
import com.consol.citrus.mail.message.MailMessage;
import com.consol.citrus.mail.model.AttachmentPart;
import com.consol.citrus.mail.model.BodyPart;
import com.consol.citrus.mail.model.MailRequest;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.util.FileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.xml.transform.Source;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.MimeMailMessage;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class MailMessageConverter
implements MessageConverter<MimeMailMessage, MimeMailMessage, MailEndpointConfiguration> {
    private static Logger log = LoggerFactory.getLogger(MailMessageConverter.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public MimeMailMessage convertOutbound(Message message, MailEndpointConfiguration endpointConfiguration, TestContext context) {
        MailRequest mailMessage = this.getMailRequest(message, endpointConfiguration);
        try {
            MimeMessage mimeMessage = endpointConfiguration.getJavaMailSender().createMimeMessage();
            MimeMailMessage mimeMailMessage = new MimeMailMessage(new MimeMessageHelper(mimeMessage, mailMessage.getBody().hasAttachments(), MailMessageConverter.parseCharsetFromContentType(mailMessage.getBody().getContentType())));
            this.convertOutbound(mimeMailMessage, (Message)new DefaultMessage((Object)mailMessage, message.getHeaders()), endpointConfiguration, context);
            return mimeMailMessage;
        }
        catch (MessagingException e) {
            throw new CitrusRuntimeException("Failed to create mail mime message", (Throwable)e);
        }
    }

    public void convertOutbound(MimeMailMessage mimeMailMessage, Message message, MailEndpointConfiguration endpointConfiguration, TestContext context) {
        MailRequest mailRequest = this.getMailRequest(message, endpointConfiguration);
        try {
            mimeMailMessage.setFrom(mailRequest.getFrom());
            mimeMailMessage.setTo(StringUtils.commaDelimitedListToStringArray((String)mailRequest.getTo()));
            if (StringUtils.hasText((String)mailRequest.getCc())) {
                mimeMailMessage.setCc(StringUtils.commaDelimitedListToStringArray((String)mailRequest.getCc()));
            }
            if (StringUtils.hasText((String)mailRequest.getBcc())) {
                mimeMailMessage.setBcc(StringUtils.commaDelimitedListToStringArray((String)mailRequest.getBcc()));
            }
            mimeMailMessage.setReplyTo(mailRequest.getReplyTo() != null ? mailRequest.getReplyTo() : mailRequest.getFrom());
            mimeMailMessage.setSentDate(new Date());
            mimeMailMessage.setSubject(mailRequest.getSubject());
            mimeMailMessage.setText(mailRequest.getBody().getContent());
            if (mailRequest.getBody().hasAttachments()) {
                for (AttachmentPart attachmentPart : mailRequest.getBody().getAttachments().getAttachments()) {
                    ByteArrayResource inputStreamSource = new ByteArrayResource(attachmentPart.getContent().getBytes(Charset.forName(MailMessageConverter.parseCharsetFromContentType(attachmentPart.getContentType()))));
                    mimeMailMessage.getMimeMessageHelper().addAttachment(attachmentPart.getFileName(), (InputStreamSource)inputStreamSource, attachmentPart.getContentType());
                }
            }
        }
        catch (MessagingException e) {
            throw new CitrusRuntimeException("Failed to create mail mime message", (Throwable)e);
        }
    }

    public MailMessage convertInbound(MimeMailMessage message, MailEndpointConfiguration endpointConfiguration, TestContext context) {
        try {
            Map<String, Object> messageHeaders = this.createMessageHeaders(message);
            return this.createMailRequest(messageHeaders, this.handlePart((MimePart)message.getMimeMessage()), endpointConfiguration);
        }
        catch (IOException | MessagingException e) {
            throw new CitrusRuntimeException("Failed to convert mail mime message", e);
        }
    }

    protected MailMessage createMailRequest(Map<String, Object> messageHeaders, BodyPart bodyPart, MailEndpointConfiguration endpointConfiguration) {
        return MailMessage.request(messageHeaders).marshaller(endpointConfiguration.getMarshaller()).from(messageHeaders.get("citrus_mail_from").toString()).to(messageHeaders.get("citrus_mail_to").toString()).cc(messageHeaders.get("citrus_mail_cc").toString()).bcc(messageHeaders.get("citrus_mail_bcc").toString()).subject(messageHeaders.get("citrus_mail_subject").toString()).body(bodyPart);
    }

    protected Map<String, Object> createMessageHeaders(MimeMailMessage msg) throws MessagingException, IOException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("citrus_mail_message_id", msg.getMimeMessage().getMessageID());
        headers.put("citrus_mail_from", StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getFrom()));
        headers.put("citrus_mail_to", StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getRecipients(Message.RecipientType.TO)));
        headers.put("citrus_mail_cc", StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getRecipients(Message.RecipientType.CC)));
        headers.put("citrus_mail_bcc", StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getRecipients(Message.RecipientType.BCC)));
        headers.put("citrus_mail_reply_to", StringUtils.arrayToCommaDelimitedString((Object[])msg.getMimeMessage().getReplyTo()));
        headers.put("citrus_mail_date", msg.getMimeMessage().getSentDate() != null ? this.dateFormat.format(msg.getMimeMessage().getSentDate()) : null);
        headers.put("citrus_mail_subject", msg.getMimeMessage().getSubject());
        headers.put("citrus_mail_content_type", MailMessageConverter.parseContentType(msg.getMimeMessage().getContentType()));
        return headers;
    }

    protected BodyPart handlePart(MimePart part) throws IOException, MessagingException {
        String contentType = MailMessageConverter.parseContentType(part.getContentType());
        if (part.isMimeType("multipart/*")) {
            return this.handleMultiPart((Multipart)part.getContent());
        }
        if (part.isMimeType("text/*")) {
            return this.handleTextPart(part, contentType);
        }
        if (part.isMimeType("image/*")) {
            return this.handleImageBinaryPart(part, contentType);
        }
        if (part.isMimeType("application/*")) {
            return this.handleApplicationContentPart(part, contentType);
        }
        return this.handleBinaryPart(part, contentType);
    }

    private BodyPart handleMultiPart(Multipart body) throws IOException, MessagingException {
        BodyPart bodyPart = null;
        for (int i = 0; i < body.getCount(); ++i) {
            MimePart entity = (MimePart)body.getBodyPart(i);
            if (bodyPart == null) {
                bodyPart = this.handlePart(entity);
                continue;
            }
            BodyPart attachment = this.handlePart(entity);
            bodyPart.addPart(new AttachmentPart(attachment.getContent(), MailMessageConverter.parseContentType(attachment.getContentType()), entity.getFileName()));
        }
        return bodyPart;
    }

    protected BodyPart handleApplicationContentPart(MimePart applicationData, String contentType) throws IOException, MessagingException {
        if (applicationData.isMimeType("application/pdf")) {
            return this.handleImageBinaryPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/rtf")) {
            return this.handleImageBinaryPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/java")) {
            return this.handleTextPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/x-javascript")) {
            return this.handleTextPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/xhtml+xml")) {
            return this.handleTextPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/json")) {
            return this.handleTextPart(applicationData, contentType);
        }
        if (applicationData.isMimeType("application/postscript")) {
            return this.handleTextPart(applicationData, contentType);
        }
        return this.handleBinaryPart(applicationData, contentType);
    }

    protected BodyPart handleImageBinaryPart(MimePart image, String contentType) throws IOException, MessagingException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileCopyUtils.copy((InputStream)image.getInputStream(), (OutputStream)bos);
        String base64 = Base64.encodeBase64String((byte[])bos.toByteArray());
        return new BodyPart(base64, contentType);
    }

    protected BodyPart handleBinaryPart(MimePart mediaPart, String contentType) throws IOException, MessagingException {
        String contentId = mediaPart.getContentID() != null ? "(" + mediaPart.getContentID() + ")" : "";
        return new BodyPart(mediaPart.getFileName() + contentId, contentType);
    }

    protected BodyPart handleTextPart(MimePart textPart, String contentType) throws IOException, MessagingException {
        String content;
        if (textPart.getContent() instanceof String) {
            content = (String)textPart.getContent();
        } else if (textPart.getContent() instanceof InputStream) {
            content = FileUtils.readToString((InputStream)((InputStream)textPart.getContent()), (Charset)Charset.forName(MailMessageConverter.parseCharsetFromContentType(contentType)));
        } else {
            throw new CitrusRuntimeException("Cannot handle text content of type: " + textPart.getContent().getClass().toString());
        }
        return new BodyPart(this.stripMailBodyEnding(content), contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String stripMailBodyEnding(String textBody) throws IOException {
        BufferedReader reader = null;
        StringBuilder body = new StringBuilder();
        try {
            reader = new BufferedReader(new StringReader(textBody));
            String line = reader.readLine();
            while (line != null && !line.equals(".")) {
                body.append(line);
                body.append(System.getProperty("line.separator"));
                line = reader.readLine();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close reader", (Throwable)e);
                }
            }
        }
        return body.toString().trim();
    }

    private MailRequest getMailRequest(Message message, MailEndpointConfiguration endpointConfiguration) {
        Object payload = message.getPayload();
        MailRequest mailRequest = null;
        if (payload != null) {
            mailRequest = payload instanceof MailRequest ? (MailRequest)payload : (MailRequest)endpointConfiguration.getMarshaller().unmarshal((Source)message.getPayload(Source.class));
        }
        if (mailRequest == null) {
            throw new CitrusRuntimeException("Unable to create proper mail message from payload: " + payload);
        }
        return mailRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String parseContentType(String contentType) throws IOException {
        if (contentType.indexOf(System.getProperty("line.separator")) > 0) {
            BufferedReader reader = new BufferedReader(new StringReader(contentType));
            try {
                String plainContentType = reader.readLine();
                if (plainContentType != null && plainContentType.trim().endsWith(";")) {
                    plainContentType = plainContentType.trim().substring(0, plainContentType.length() - 1);
                }
                String string = plainContentType;
                return string;
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.warn("Failed to close reader", (Throwable)e);
                }
            }
        }
        return contentType;
    }

    static String parseCharsetFromContentType(String contentType) {
        String charsetPrefix = "charset=";
        if (org.apache.commons.lang.StringUtils.contains((String)contentType, (String)"charset=")) {
            String charsetName = org.apache.commons.lang.StringUtils.substringAfter((String)contentType, (String)"charset=");
            return org.apache.commons.lang.StringUtils.substringBefore((String)charsetName, (String)";");
        }
        return CitrusSettings.CITRUS_FILE_ENCODING;
    }
}

