/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.model;

import com.consol.citrus.mail.model.AttachmentPart;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.springframework.util.CollectionUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BodyPart", propOrder={"contentType", "content", "attachments"})
@XmlSeeAlso(value={AttachmentPart.class})
public class BodyPart {
    @XmlElement(required=true)
    protected String contentType;
    @XmlElement(required=true)
    protected String content;
    protected Attachments attachments;

    public BodyPart() {
    }

    public BodyPart(String content, String contentType) {
        this.content = content;
        this.contentType = contentType;
    }

    public void addPart(AttachmentPart part) {
        if (this.attachments == null) {
            this.attachments = new Attachments();
        }
        this.attachments.add(part);
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Attachments attachments) {
        this.attachments = attachments;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !CollectionUtils.isEmpty(this.attachments.getAttachments());
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={"attachments"})
    public static class Attachments {
        @XmlElement(name="attachment", required=true)
        protected List<AttachmentPart> attachments = new ArrayList<AttachmentPart>();

        public List<AttachmentPart> getAttachments() {
            return this.attachments;
        }

        public void add(AttachmentPart attachmentPart) {
            this.attachments.add(attachmentPart);
        }
    }
}

