/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.mail.model;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.mail.model.AcceptRequest;
import com.consol.citrus.mail.model.AcceptResponse;
import com.consol.citrus.mail.model.MailRequest;
import com.consol.citrus.mail.model.MailResponse;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.xml.Jaxb2Marshaller;
import com.consol.citrus.xml.Marshaller;
import com.consol.citrus.xml.StringResult;
import com.consol.citrus.xml.Unmarshaller;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class MailMarshaller
implements Marshaller,
Unmarshaller {
    private static final Logger log = LoggerFactory.getLogger(MailMarshaller.class);
    private static final String MAIL_MARSHALLER_TYPE_PROPERTY = "citrus.mail.marshaller.type";
    private String type;
    private final ObjectMapper mapper;
    private final Jaxb2Marshaller marshaller;
    private final Class<?>[] classesToBeBound = new Class[]{AcceptRequest.class, AcceptResponse.class, MailRequest.class, MailResponse.class};

    public MailMarshaller() {
        this.mapper = new ObjectMapper();
        this.marshaller = new Jaxb2Marshaller((Resource)new ClassPathResource("com/consol/citrus/schema/citrus-mail-message.xsd"), (Class[])this.classesToBeBound);
        this.type = System.getProperty(MAIL_MARSHALLER_TYPE_PROPERTY, MessageType.XML.name());
    }

    public Object unmarshal(Source source) {
        if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException e) {
                if (source instanceof StreamSource) {
                    for (Class<?> type : this.classesToBeBound) {
                        try {
                            return this.mapper.readValue(((StreamSource)source).getReader(), type);
                        }
                        catch (JsonParseException | JsonMappingException e2) {
                        }
                        catch (IOException io) {
                            log.warn("Unable to read mail JSON object from source", (Throwable)io);
                            throw new CitrusRuntimeException("Failed to unmarshal source", (Throwable)io);
                        }
                    }
                }
                throw new CitrusRuntimeException("Failed to unmarshal source", (Throwable)e);
            }
        }
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            for (Class<?> type : this.classesToBeBound) {
                try {
                    return this.mapper.readValue(((StreamSource)source).getReader(), type);
                }
                catch (JsonParseException | JsonMappingException e2) {
                }
                catch (IOException io) {
                    throw new CitrusRuntimeException("Unable to read mail JSON object from source", (Throwable)io);
                }
            }
            throw new CitrusRuntimeException("Failed to read mail JSON object from source:" + source);
        }
        throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
    }

    public void marshal(Object graph, Result result) {
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            if (result instanceof StringResult) {
                StringWriter writer = new StringWriter();
                ((StringResult)result).setWriter((Writer)writer);
                try {
                    this.mapper.writer().writeValue((Writer)writer, graph);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to write mail object graph to result", (Throwable)e);
                }
            }
        } else if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                this.marshaller.marshal(graph, result);
            }
            catch (JAXBException e) {
                throw new CitrusRuntimeException("Failed to marshal object graph", (Throwable)e);
            }
        } else {
            throw new CitrusRuntimeException("Unsupported mail marshaller type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

