/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.main;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.junit.JUnit4TestEngine;
import com.consol.citrus.main.CitrusAppConfiguration;
import com.consol.citrus.main.CitrusAppOptions;
import com.consol.citrus.main.TestRunConfiguration;
import com.consol.citrus.testng.TestNGEngine;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class CitrusApp {
    private static Logger log = LoggerFactory.getLogger(CitrusApp.class);
    private final CitrusAppConfiguration configuration;
    protected final CompletableFuture<Boolean> completed = new CompletableFuture();

    public CitrusApp() {
        this(new CitrusAppConfiguration());
    }

    public CitrusApp(CitrusAppConfiguration configuration) {
        this.configuration = configuration;
    }

    public CitrusApp(String[] args) {
        this(CitrusAppOptions.apply(args));
    }

    public static void main(String[] args) {
        CitrusApp citrusApp = new CitrusApp(args);
        if (citrusApp.configuration.getTimeToLive() > 0L) {
            CompletableFuture.runAsync(() -> {
                try {
                    new CompletableFuture().get(citrusApp.configuration.getTimeToLive(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    log.info(String.format("Shutdown Citrus application after %s ms", citrusApp.configuration.getTimeToLive()));
                    citrusApp.stop();
                }
            });
        }
        if (citrusApp.configuration.isSkipTests()) {
            if (citrusApp.configuration.getConfigClass() != null) {
                Citrus.newInstance((CitrusContext)CitrusSpringContext.create(citrusApp.configuration.getConfigClass()));
            } else {
                Citrus.newInstance((CitrusContext)CitrusSpringContext.create());
            }
            CitrusApp.setDefaultProperties(citrusApp.configuration);
        } else {
            try {
                citrusApp.run();
            }
            finally {
                if (citrusApp.configuration.getTimeToLive() == 0L) {
                    citrusApp.stop();
                }
            }
        }
        if (citrusApp.configuration.isSystemExit()) {
            if (citrusApp.waitForCompletion()) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        } else {
            citrusApp.waitForCompletion();
        }
    }

    public void run() {
        if (this.isCompleted()) {
            log.info("Not executing tests as application state is completed!");
            return;
        }
        log.info(String.format("Running Citrus %s", Citrus.getVersion()));
        CitrusApp.setDefaultProperties(this.configuration);
        if (ClassUtils.isPresent((String)"org.testng.annotations.Test", (ClassLoader)this.getClass().getClassLoader())) {
            new TestNGEngine((TestRunConfiguration)this.configuration).run();
        } else if (ClassUtils.isPresent((String)"org.junit.Test", (ClassLoader)this.getClass().getClassLoader())) {
            new JUnit4TestEngine((TestRunConfiguration)this.configuration).run();
        }
    }

    public void complete() {
        this.completed.complete(true);
    }

    public boolean waitForCompletion() {
        try {
            return this.completed.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to wait for application completion", (Throwable)e);
            return false;
        }
    }

    private void stop() {
        this.complete();
        Citrus citrus = CitrusInstanceManager.getSingleton();
        if (citrus != null) {
            log.info("Closing Citrus and its application context");
            citrus.close();
        }
    }

    private static void setDefaultProperties(CitrusAppConfiguration configuration) {
        for (Map.Entry entry : configuration.getDefaultProperties().entrySet()) {
            log.debug(String.format("Setting application property %s=%s", entry.getKey(), entry.getValue()));
            System.setProperty((String)entry.getKey(), Optional.ofNullable(entry.getValue()).orElse(""));
        }
    }

    public boolean isCompleted() {
        return this.completed.isDone();
    }
}

