/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.main;

import com.consol.citrus.TestClass;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.main.CitrusAppConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CitrusAppOptions {
    private static Logger log = LoggerFactory.getLogger(CitrusAppOptions.class);
    protected final List<CliOption<? extends CitrusAppConfiguration>> options = new ArrayList<CliOption<? extends CitrusAppConfiguration>>();

    protected CitrusAppOptions() {
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("h", "help", "Displays cli option usage"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                StringBuilder builder = new StringBuilder();
                builder.append(System.lineSeparator()).append("Citrus application option usage:").append(System.lineSeparator());
                for (CliOption<? extends CitrusAppConfiguration> option : CitrusAppOptions.this.options) {
                    builder.append(option.getInformation()).append(System.lineSeparator());
                }
                log.info(builder.toString());
                configuration.setTimeToLive(1000L);
                configuration.setSkipTests(true);
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("d", "duration", "Maximum time in milliseconds the server should be up and running - server will terminate automatically when time exceeds"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (value == null || value.length() <= 0) {
                    throw new CitrusRuntimeException("Missing parameter value for -d/--duration option");
                }
                configuration.setTimeToLive(Long.valueOf(value));
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("c", "config", "Custom Spring configuration class"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (StringUtils.hasText((String)value)) {
                    try {
                        configuration.setConfigClass(Class.forName(value));
                    }
                    catch (ClassNotFoundException e) {
                        throw new CitrusRuntimeException("Unable to access config class type: " + value, (Throwable)e);
                    }
                } else {
                    throw new CitrusRuntimeException("Missing parameter value for -c/--config option");
                }
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("s", "skipTests", "Skip test execution"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -s/--skipTests option");
                }
                configuration.setSkipTests(Boolean.valueOf(value));
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("p", "package", "Test package to execute"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -p/--package option");
                }
                configuration.getPackages().add(value);
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("D", "properties", "Default system properties to set"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -D/--properties option");
                }
                configuration.getDefaultProperties().putAll(StringUtils.commaDelimitedListToSet((String)value).stream().map(keyValue -> Optional.ofNullable(StringUtils.split((String)keyValue, (String)"=")).orElse(new String[]{keyValue, ""})).collect(Collectors.toMap(keyValue -> keyValue[0], keyValue -> keyValue[1])));
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("e", "exit", "Force system exit when finished"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -e/--exit option");
                }
                configuration.setSystemExit(Boolean.valueOf(value));
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("t", "test", "Test class/method to execute"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                TestClass testClass;
                if (StringUtils.hasText((String)value)) {
                    String className = value;
                    String methodName = null;
                    if (value.contains("#")) {
                        className = value.substring(0, value.indexOf("#"));
                        methodName = value.substring(value.indexOf("#") + 1);
                    }
                    testClass = new TestClass(className);
                    if (StringUtils.hasText(methodName)) {
                        testClass.setMethod(methodName);
                    }
                } else {
                    throw new CitrusRuntimeException("Missing parameter value for -t/--test option");
                }
                configuration.getTestClasses().add(testClass);
            }
        });
        this.options.add((CliOption<? extends CitrusAppConfiguration>)new CliOption<CitrusAppConfiguration>("j", "jar", "External test jar to load tests from"){

            @Override
            protected void doProcess(CitrusAppConfiguration configuration, String arg, String value, LinkedList<String> remainingArgs) {
                if (!StringUtils.hasText((String)value)) {
                    throw new CitrusRuntimeException("Missing parameter value for -j/--jar option");
                }
                configuration.setTestJar(new File(value));
            }
        });
    }

    public static CitrusAppConfiguration apply(String[] arguments) {
        return CitrusAppOptions.apply(new CitrusAppConfiguration(), arguments);
    }

    public static <T extends CitrusAppConfiguration> T apply(T configuration, String[] arguments) {
        LinkedList<String> args = new LinkedList<String>(Arrays.asList(arguments));
        CitrusAppOptions options = new CitrusAppOptions();
        while (!args.isEmpty()) {
            String arg = args.removeFirst();
            for (CliOption<? extends CitrusAppConfiguration> option : options.options) {
                if (option.processOption(configuration, arg, args)) break;
            }
        }
        return configuration;
    }

    public abstract class CliOption<T extends CitrusAppConfiguration> {
        private String shortName;
        private String fullName;
        private String description;

        protected CliOption(String shortName, String fullName, String description) {
            this.shortName = "-" + shortName;
            this.fullName = "--" + fullName;
            this.description = description;
        }

        public boolean processOption(T configuration, String arg, LinkedList<String> remainingArgs) {
            if (arg.equals(this.shortName) || this.fullName.startsWith(arg)) {
                if (remainingArgs.isEmpty()) {
                    this.doProcess(configuration, arg, null, remainingArgs);
                } else {
                    this.doProcess(configuration, arg, remainingArgs.removeFirst(), remainingArgs);
                }
                return true;
            }
            return false;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getDescription() {
            return this.description;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getInformation() {
            return "  " + this.getShortName() + " or " + this.getFullName() + " = " + this.getDescription();
        }

        protected abstract void doProcess(T var1, String var2, String var3, LinkedList<String> var4);
    }
}

