/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.main;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.main.CitrusAppConfiguration;
import com.consol.citrus.main.CitrusAppOptions;
import com.consol.citrus.main.TestEngine;
import com.consol.citrus.main.TestRunConfiguration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CitrusApp {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusApp.class);
    private final CitrusAppConfiguration configuration;
    protected final CompletableFuture<Boolean> completed = new CompletableFuture();

    public CitrusApp() {
        this(new CitrusAppConfiguration());
    }

    public CitrusApp(CitrusAppConfiguration configuration) {
        this.configuration = configuration;
    }

    public CitrusApp(String[] args) {
        this((CitrusAppConfiguration)((Object)new CitrusAppOptions().apply(args)));
    }

    public static void main(String[] args) {
        CitrusApp citrusApp = new CitrusApp(args);
        if (citrusApp.configuration.getTimeToLive() > 0L) {
            CompletableFuture.runAsync(() -> {
                try {
                    new CompletableFuture().get(citrusApp.configuration.getTimeToLive(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    LOG.info(String.format("Shutdown Citrus application after %s ms", citrusApp.configuration.getTimeToLive()));
                    citrusApp.stop();
                }
            });
        }
        if (citrusApp.configuration.isSkipTests()) {
            citrusApp.configuration.setDefaultProperties();
            CitrusInstanceManager.getOrDefault();
        } else {
            try {
                citrusApp.run();
            }
            finally {
                if (citrusApp.configuration.getTimeToLive() == 0L) {
                    citrusApp.stop();
                }
            }
        }
        if (citrusApp.configuration.isSystemExit()) {
            if (citrusApp.waitForCompletion()) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        } else {
            citrusApp.waitForCompletion();
        }
    }

    public void run() {
        if (this.isCompleted()) {
            LOG.info("Not executing tests as application state is completed!");
            return;
        }
        LOG.info(String.format("Running Citrus %s", Citrus.getVersion()));
        this.configuration.setDefaultProperties();
        TestEngine.lookup((TestRunConfiguration)this.configuration).run();
    }

    public void complete() {
        this.completed.complete(true);
    }

    public boolean waitForCompletion() {
        try {
            return this.completed.get();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to wait for application completion", (Throwable)e);
            return false;
        }
    }

    private void stop() {
        this.complete();
        Optional citrus = CitrusInstanceManager.get();
        if (citrus.isPresent()) {
            LOG.info("Closing Citrus and its context");
            ((Citrus)citrus.get()).close();
        }
    }

    public boolean isCompleted() {
        return this.completed.isDone();
    }
}

