/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin;

import com.consol.citrus.TestClass;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.main.TestRunConfiguration;
import com.consol.citrus.remote.model.RemoteResult;
import com.consol.citrus.remote.plugin.AbstractCitrusRemoteMojo;
import com.consol.citrus.remote.plugin.config.RunConfiguration;
import com.consol.citrus.report.HtmlReporter;
import com.consol.citrus.report.JUnitReporter;
import com.consol.citrus.report.OutputStreamReporter;
import com.consol.citrus.report.SummaryReporter;
import com.consol.citrus.report.TestResults;
import com.consol.citrus.util.FileUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class RunTestMojo
extends AbstractCitrusRemoteMojo {
    private static final String ENCODING = "UTF-8";
    @Parameter(property="citrus.remote.skip.test", defaultValue="false")
    protected boolean skipRun;
    @Parameter
    private RunConfiguration run;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipRun) {
            return;
        }
        if (this.run == null) {
            this.run = new RunConfiguration();
        }
        if (!this.run.hasClasses() && !this.run.hasPackages()) {
            this.runAllTests();
        }
        if (this.run.hasClasses()) {
            this.runClasses(this.run.getClasses());
        }
        if (this.run.hasPackages()) {
            this.runPackages(this.run.getPackages());
        }
    }

    private void runPackages(List<String> packages) throws MojoExecutionException {
        TestRunConfiguration runConfiguration = new TestRunConfiguration();
        runConfiguration.setEngine(this.run.getEngine());
        runConfiguration.setPackages(packages);
        if (this.run.getIncludes() != null) {
            runConfiguration.setIncludes(this.run.getIncludes().toArray(new String[this.run.getIncludes().size()]));
        }
        if (this.run.getSystemProperties() != null) {
            runConfiguration.addDefaultProperties(this.run.getSystemProperties());
        }
        this.runTests(runConfiguration);
    }

    private void runClasses(List<String> classes) throws MojoExecutionException {
        TestRunConfiguration runConfiguration = new TestRunConfiguration();
        runConfiguration.setEngine(this.run.getEngine());
        runConfiguration.setTestClasses(classes.stream().map(TestClass::fromString).collect(Collectors.toList()));
        if (this.run.getSystemProperties() != null) {
            runConfiguration.addDefaultProperties(this.run.getSystemProperties());
        }
        this.runTests(runConfiguration);
    }

    private void runAllTests() throws MojoExecutionException {
        TestRunConfiguration runConfiguration = new TestRunConfiguration();
        runConfiguration.setEngine(this.run.getEngine());
        if (this.run.getIncludes() != null) {
            runConfiguration.setIncludes(this.run.getIncludes().toArray(new String[this.run.getIncludes().size()]));
        }
        if (this.run.getSystemProperties() != null) {
            runConfiguration.addDefaultProperties(this.run.getSystemProperties());
        }
        this.runTests(runConfiguration);
    }

    private void runTests(TestRunConfiguration runConfiguration) throws MojoExecutionException {
        HttpResponse response;
        block6: {
            response = null;
            try {
                RequestBuilder requestBuilder = this.run.isAsync() ? RequestBuilder.put((String)(this.getServer().getUrl() + "/run")) : RequestBuilder.post((String)(this.getServer().getUrl() + "/run"));
                requestBuilder.addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType()));
                StringEntity body = new StringEntity(new ObjectMapper().writeValueAsString((Object)runConfiguration), ContentType.APPLICATION_JSON);
                requestBuilder.setEntity((HttpEntity)body);
                response = this.getHttpClient().execute(requestBuilder.build());
                if (200 != response.getStatusLine().getStatusCode()) {
                    throw new MojoExecutionException("Failed to run tests on remote server: " + EntityUtils.toString((HttpEntity)response.getEntity()));
                }
                if (this.run.isAsync()) {
                    HttpClientUtils.closeQuietly((HttpResponse)response);
                    this.handleTestResults(this.pollTestResults());
                    break block6;
                }
                this.handleTestResults((RemoteResult[])this.objectMapper.readValue(response.getEntity().getContent(), RemoteResult[].class));
            }
            catch (IOException e) {
                try {
                    throw new MojoExecutionException("Failed to run tests on remote server", (Exception)e);
                }
                catch (Throwable throwable) {
                    HttpClientUtils.closeQuietly(response);
                    throw throwable;
                }
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
    }

    private RemoteResult[] pollTestResults() throws MojoExecutionException {
        RemoteResult[] remoteResultArray;
        HttpResponse response = null;
        try {
            do {
                HttpClientUtils.closeQuietly(response);
                response = this.getHttpClient().execute(RequestBuilder.get((String)(this.getServer().getUrl() + "/results")).addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_JSON.getMimeType())).addParameter("timeout", String.valueOf(this.run.getPollingInterval())).build());
                if (206 != response.getStatusLine().getStatusCode()) continue;
                this.getLog().info((CharSequence)"Waiting for remote tests to finish ...");
                this.getLog().info((CharSequence)Stream.of((RemoteResult[])this.objectMapper.readValue(response.getEntity().getContent(), RemoteResult[].class)).map(RemoteResult::toTestResult).map(result -> result.isSkipped() ? "x" : (result.isSuccess() ? "+" : "-")).collect(Collectors.joining()));
            } while (206 == response.getStatusLine().getStatusCode());
            if (200 != response.getStatusLine().getStatusCode()) {
                throw new MojoExecutionException("Failed to get test results from remote server: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            remoteResultArray = (RemoteResult[])this.objectMapper.readValue(response.getEntity().getContent(), RemoteResult[].class);
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Failed to get test results from remote server", (Exception)e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly((HttpResponse)response);
        return remoteResultArray;
    }

    private void handleTestResults(RemoteResult[] results) {
        StringWriter resultWriter = new StringWriter();
        resultWriter.append(String.format("%n", new Object[0]));
        TestResults testResults = new TestResults();
        Arrays.stream(results).forEach(remoteResult -> testResults.addResult(RemoteResult.toTestResult((RemoteResult)remoteResult)));
        OutputStreamReporter reporter = new OutputStreamReporter((Writer)resultWriter);
        reporter.generate(testResults);
        this.getLog().info((CharSequence)resultWriter.toString());
        if (this.getReport().isHtmlReport()) {
            HtmlReporter htmlReporter = new HtmlReporter();
            htmlReporter.setReportDirectory(this.getOutputDirectory().getPath() + File.separator + this.getReport().getDirectory());
            htmlReporter.generate(testResults);
        }
        SummaryReporter summaryReporter = new SummaryReporter();
        summaryReporter.setReportDirectory(this.getOutputDirectory().getPath() + File.separator + this.getReport().getDirectory());
        summaryReporter.setReportFileName(this.getReport().getSummaryFile());
        summaryReporter.generate(testResults);
        this.getAndSaveReports();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAndSaveReports() {
        if (!this.getReport().isSaveReportFiles()) {
            return;
        }
        HttpResponse response = null;
        String[] reportFiles = new String[]{};
        try {
            response = this.getHttpClient().execute(RequestBuilder.get((String)(this.getServer().getUrl() + "/results/files")).addHeader((Header)new BasicHeader("Accept", ContentType.APPLICATION_XML.getMimeType())).build());
            if (200 != response.getStatusLine().getStatusCode()) {
                this.getLog().warn((CharSequence)"Failed to get test reports from remote server");
            }
            reportFiles = (String[])this.objectMapper.readValue(response.getEntity().getContent(), String[].class);
            HttpClientUtils.closeQuietly((HttpResponse)response);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)"Failed to get test reports from remote server", (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly(response);
        }
        File citrusReportsDirectory = new File(this.getOutputDirectory() + File.separator + this.getReport().getDirectory());
        if (!citrusReportsDirectory.exists() && !citrusReportsDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create reports output directory: " + citrusReportsDirectory.getPath());
        }
        File junitReportsDirectory = new File(citrusReportsDirectory, "junitreports");
        if (!junitReportsDirectory.exists() && !junitReportsDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create JUnit reports directory: " + junitReportsDirectory.getPath());
        }
        JUnitReporter jUnitReporter = new JUnitReporter();
        this.loadAndSaveReportFile(new File(citrusReportsDirectory, String.format(jUnitReporter.getReportFileNamePattern(), jUnitReporter.getSuiteName())), this.getServer().getUrl() + "/results/suite", ContentType.APPLICATION_XML.getMimeType());
        Stream.of(reportFiles).map(reportFile -> new File(junitReportsDirectory, (String)reportFile)).forEach(reportFile -> {
            try {
                this.loadAndSaveReportFile((File)reportFile, this.getServer().getUrl() + "/results/file/" + URLEncoder.encode(reportFile.getName(), ENCODING), ContentType.APPLICATION_XML.getMimeType());
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Failed to get report file: " + reportFile.getName()), (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAndSaveReportFile(File reportFile, String serverUrl, String contentType) {
        HttpResponse fileResponse = null;
        try {
            fileResponse = this.getHttpClient().execute(RequestBuilder.get((String)serverUrl).addHeader((Header)new BasicHeader("Accept", contentType)).build());
            if (200 != fileResponse.getStatusLine().getStatusCode()) {
                this.getLog().warn((CharSequence)("Failed to get report file: " + reportFile.getName()));
                HttpClientUtils.closeQuietly((HttpResponse)fileResponse);
                return;
            }
            this.getLog().info((CharSequence)("Writing report file: " + reportFile));
            FileUtils.writeToFile((InputStream)fileResponse.getEntity().getContent(), (File)reportFile);
            HttpClientUtils.closeQuietly((HttpResponse)fileResponse);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Failed to get report file: " + reportFile.getName()), (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly(fileResponse);
        }
    }

    public void setTests(RunConfiguration tests) {
        this.run = tests;
    }
}

