/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin;

import com.consol.citrus.remote.plugin.AbstractCitrusRemoteAssemblyMojo;
import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="test-jar", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class TestJarMojo
extends AbstractCitrusRemoteAssemblyMojo {
    @Parameter(property="citrus.skip.test.jar", defaultValue="false")
    protected boolean skipTestJar;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkip()) {
            return;
        }
        if (this.hasTestJar() || this.getAssembly().isTestJarProvided()) {
            this.getLog().info((CharSequence)String.format("Skip test-jar creation as it is already attached to the project (classifier='%s')", this.getTestJar().getClassifier()));
        } else {
            this.createTestJarArchive();
        }
        super.doExecute();
    }

    protected boolean shouldSkip() {
        return this.skipTestJar;
    }

    @Override
    protected String getDefaultDescriptorRef() {
        return "test-jar";
    }

    private boolean hasTestJar() {
        return this.project.getAttachedArtifacts().stream().filter(Artifact::hasClassifier).map(Artifact::getClassifier).anyMatch(c -> c.equals(this.getTestJar().getClassifier()));
    }

    public void createTestJarArchive() throws MojoExecutionException {
        File jarFile = new File(this.getOutputDirectory(), this.getFinalName() + "-" + this.getTestJar().getClassifier() + ".jar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        try {
            if (!this.getTestJar().getTestClassesDirectory().exists()) {
                this.getLog().warn((CharSequence)"Tests jar will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(this.getTestJar().getTestClassesDirectory(), this.getTestJar().getIncludes(), this.getTestJar().getExcludes());
            }
            archiver.createArchive(this.session, this.project, new MavenArchiveConfiguration());
            this.projectHelper.attachArtifact(this.project, "test-jar", this.getTestJar().getClassifier(), jarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling tests jar", e);
        }
    }
}

