/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin.assembly;

import com.consol.citrus.remote.plugin.config.AssemblyConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.utils.InterpolationConstants;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenReaderFilter;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.codehaus.plexus.interpolation.fixed.FixedStringSearchInterpolator;
import org.codehaus.plexus.interpolation.fixed.FixedValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.fixed.PrefixedPropertiesValueSource;
import org.codehaus.plexus.interpolation.fixed.PropertiesBasedValueSource;

public class CitrusRemoteAssemblerConfigurationSource
implements AssemblerConfigurationSource {
    private final MavenProject project;
    private final MavenSession session;
    private final MavenReaderFilter readerFilter;
    private final List<MavenProject> reactorProjects;
    private final AssemblyConfiguration assemblyConfig;
    private FixedStringSearchInterpolator commandLinePropertiesInterpolator;
    private FixedStringSearchInterpolator envInterpolator;
    private FixedStringSearchInterpolator rootInterpolator;
    private FixedStringSearchInterpolator mainProjectInterpolator;

    public CitrusRemoteAssemblerConfigurationSource(AssemblyConfiguration assemblyConfig, MavenProject project, MavenSession session, MavenReaderFilter readerFilter, List<MavenProject> reactorProjects) {
        this.assemblyConfig = assemblyConfig;
        this.project = project;
        this.session = session;
        this.readerFilter = readerFilter;
        this.reactorProjects = reactorProjects;
    }

    public String[] getDescriptors() {
        String descriptor;
        if (this.assemblyConfig != null && (descriptor = this.assemblyConfig.getDescriptor().getFile()) != null) {
            return new String[]{new File(descriptor).getAbsolutePath()};
        }
        return new String[0];
    }

    public String[] getDescriptorReferences() {
        String descriptorRef;
        if (this.assemblyConfig != null && (descriptorRef = this.assemblyConfig.getDescriptor().getRef()) != null) {
            return new String[]{descriptorRef};
        }
        return null;
    }

    public File getOutputDirectory() {
        return this.assemblyConfig.getOutputDirectory();
    }

    public File getWorkingDirectory() {
        return this.assemblyConfig.getWorkingDirectory();
    }

    public File getTemporaryRootDirectory() {
        return this.assemblyConfig.getTemporaryRootDirectory();
    }

    public String getFinalName() {
        return ".";
    }

    public ArtifactRepository getLocalRepository() {
        return this.session.getLocalRepository();
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.project.getRemoteArtifactRepositories();
    }

    public MavenSession getMavenSession() {
        return this.session;
    }

    public MavenArchiveConfiguration getJarArchiveConfiguration() {
        return this.assemblyConfig.getArchive();
    }

    public String getEncoding() {
        return this.project.getProperties().getProperty("project.build.sourceEncoding");
    }

    public String getEscapeString() {
        return null;
    }

    public List<String> getDelimiters() {
        return null;
    }

    @Nonnull
    public FixedStringSearchInterpolator getCommandLinePropsInterpolator() {
        if (this.commandLinePropertiesInterpolator == null) {
            this.commandLinePropertiesInterpolator = this.createCommandLinePropertiesInterpolator();
        }
        return this.commandLinePropertiesInterpolator;
    }

    @Nonnull
    public FixedStringSearchInterpolator getEnvInterpolator() {
        if (this.envInterpolator == null) {
            this.envInterpolator = this.createEnvInterpolator();
        }
        return this.envInterpolator;
    }

    @Nonnull
    public FixedStringSearchInterpolator getRepositoryInterpolator() {
        if (this.rootInterpolator == null) {
            this.rootInterpolator = this.createRepositoryInterpolator();
        }
        return this.rootInterpolator;
    }

    @Nonnull
    public FixedStringSearchInterpolator getMainProjectInterpolator() {
        if (this.mainProjectInterpolator == null) {
            this.mainProjectInterpolator = this.mainProjectInterpolator(this.getProject());
        }
        return this.mainProjectInterpolator;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public File getBasedir() {
        return this.project.getBasedir();
    }

    public boolean isIgnoreDirFormatExtensions() {
        return true;
    }

    public boolean isDryRun() {
        return false;
    }

    public List<String> getFilters() {
        return Collections.emptyList();
    }

    public boolean isIncludeProjectBuildFilters() {
        return true;
    }

    public File getDescriptorSourceDirectory() {
        return null;
    }

    public File getArchiveBaseDirectory() {
        return null;
    }

    public String getTarLongFileMode() {
        return "warn";
    }

    public File getSiteDirectory() {
        return null;
    }

    public boolean isAssemblyIdAppended() {
        return true;
    }

    public boolean isIgnoreMissingDescriptor() {
        return false;
    }

    public String getArchiverConfig() {
        return null;
    }

    public MavenReaderFilter getMavenReaderFilter() {
        return this.readerFilter;
    }

    public boolean isUpdateOnly() {
        return false;
    }

    public boolean isUseJvmChmod() {
        return false;
    }

    public boolean isIgnorePermissions() {
        return false;
    }

    private FixedStringSearchInterpolator mainProjectInterpolator(MavenProject mainProject) {
        if (mainProject != null) {
            return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PrefixedObjectValueSource(InterpolationConstants.PROJECT_PREFIXES, (Object)mainProject, true), new PrefixedPropertiesValueSource(InterpolationConstants.PROJECT_PROPERTIES_PREFIXES, mainProject.getProperties(), true)});
        }
        return FixedStringSearchInterpolator.empty();
    }

    private FixedStringSearchInterpolator createRepositoryInterpolator() {
        Properties settingsProperties = new Properties();
        MavenSession session = this.getMavenSession();
        if (this.getLocalRepository() != null) {
            settingsProperties.setProperty("localRepository", this.getLocalRepository().getBasedir());
            settingsProperties.setProperty("settings.localRepository", this.getLocalRepository().getBasedir());
        } else if (session != null && session.getSettings() != null) {
            settingsProperties.setProperty("localRepository", session.getSettings().getLocalRepository());
            settingsProperties.setProperty("settings.localRepository", this.getLocalRepository().getBasedir());
        }
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{new PropertiesBasedValueSource(settingsProperties)});
    }

    private FixedStringSearchInterpolator createCommandLinePropertiesInterpolator() {
        Properties commandLineProperties = System.getProperties();
        MavenSession session = this.getMavenSession();
        if (session != null) {
            commandLineProperties = new Properties();
            if (session.getSystemProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getSystemProperties());
            }
            if (session.getUserProperties() != null) {
                commandLineProperties.putAll((Map<?, ?>)session.getUserProperties());
            }
        }
        PropertiesBasedValueSource cliProps = new PropertiesBasedValueSource(commandLineProperties);
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{cliProps});
    }

    private FixedStringSearchInterpolator createEnvInterpolator() {
        PrefixedPropertiesValueSource envProps = new PrefixedPropertiesValueSource(Collections.singletonList("env."), CommandLineUtils.getSystemEnvVars((boolean)false), true);
        return FixedStringSearchInterpolator.create((FixedValueSource[])new FixedValueSource[]{envProps});
    }
}

