/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin;

import com.consol.citrus.remote.plugin.AbstractCitrusRemoteMojo;
import com.consol.citrus.remote.plugin.assembly.CitrusRemoteAssemblerConfigurationSource;
import com.consol.citrus.remote.plugin.config.AssemblyConfiguration;
import com.consol.citrus.remote.plugin.config.AssemblyDescriptorConfiguration;
import com.consol.citrus.remote.plugin.config.TestJarConfiguration;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.assembly.AssemblerConfigurationSource;
import org.apache.maven.plugins.assembly.InvalidAssemblerConfigurationException;
import org.apache.maven.plugins.assembly.archive.ArchiveCreationException;
import org.apache.maven.plugins.assembly.archive.AssemblyArchiver;
import org.apache.maven.plugins.assembly.format.AssemblyFormattingException;
import org.apache.maven.plugins.assembly.io.AssemblyReadException;
import org.apache.maven.plugins.assembly.io.AssemblyReader;
import org.apache.maven.plugins.assembly.model.Assembly;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.MavenReaderFilter;

public abstract class AbstractCitrusRemoteAssemblyMojo
extends AbstractCitrusRemoteMojo {
    @Parameter
    protected AssemblyConfiguration assembly;
    @Parameter
    protected TestJarConfiguration testJar;
    @Component
    private AssemblyArchiver assemblyArchiver;
    @Component
    private AssemblyReader assemblyReader;
    @Component
    private MavenReaderFilter readerFilter;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.build.finalName}", required=true)
    private String finalName;
    @Parameter(defaultValue="${project.build.testOutputDirectory}", required=true, readonly=true)
    private File testClassesDirectory;
    @Parameter(property="citrus.remote.mainClass", required=true, defaultValue="com.consol.citrus.remote.CitrusRemoteServer")
    private String mainClass;
    @Parameter(defaultValue="${project.build.directory}/assembly/work", readonly=true, required=true)
    private File workingDirectory;
    @Parameter(defaultValue="${project.build.directory}/assembly/tmp", readonly=true, required=true)
    private File temporaryRootDirectory;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.initializeAssembly();
        this.createDirs(this.assembly);
        this.createAssemblyArchive(this.assembly);
    }

    protected void createDirs(AssemblyConfiguration assemblyConfig) {
        for (File dir : new File[]{assemblyConfig.getTemporaryRootDirectory(), assemblyConfig.getOutputDirectory(), assemblyConfig.getWorkingDirectory()}) {
            if (dir.exists() || dir.mkdirs()) continue;
            throw new IllegalArgumentException("Cannot create directory " + dir.getAbsolutePath());
        }
    }

    private void initializeAssembly() {
        if (!this.hasAssemblyConfiguration()) {
            this.assembly = Optional.ofNullable(this.assembly).orElse(new AssemblyConfiguration());
            AssemblyDescriptorConfiguration descriptorConfiguration = new AssemblyDescriptorConfiguration();
            descriptorConfiguration.setRef(this.getDefaultDescriptorRef());
            this.assembly.setDescriptor(descriptorConfiguration);
        }
        this.assembly.setOutputDirectory(this.getOutputDirectory());
        this.assembly.setWorkingDirectory(this.workingDirectory);
        this.assembly.setTemporaryRootDirectory(this.temporaryRootDirectory);
        if (this.assembly.getArchive() == null) {
            this.assembly.setArchive(new MavenArchiveConfiguration());
        }
        if (this.assembly.getArchive().getManifest().getMainClass() == null) {
            this.assembly.getArchive().getManifest().setMainClass(this.mainClass);
        }
    }

    protected abstract String getDefaultDescriptorRef();

    protected boolean hasAssemblyConfiguration() {
        return this.assembly != null && this.assembly.getDescriptor() != null && (this.assembly.getDescriptor().getInline() != null || this.assembly.getDescriptor().getFile() != null || this.assembly.getDescriptor().getRef() != null);
    }

    protected void createAssemblyArchive(AssemblyConfiguration assemblyConfig) throws MojoExecutionException {
        CitrusRemoteAssemblerConfigurationSource source = new CitrusRemoteAssemblerConfigurationSource(assemblyConfig, this.project, this.session, this.readerFilter, this.reactorProjects);
        Assembly assembly = this.getAssemblyConfig(assemblyConfig, source);
        try {
            for (String format : assembly.getFormats()) {
                this.assemblyArchiver.createArchive(assembly, this.finalName + "-" + assembly.getId(), format, (AssemblerConfigurationSource)source, false, "merge");
            }
        }
        catch (ArchiveCreationException | AssemblyFormattingException e) {
            throw new MojoExecutionException("Failed to create assembly for test jar", (Exception)e);
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException("Invalid assembly descriptor: " + assembly.getId(), (Exception)((Object)e));
        }
    }

    private Assembly getAssemblyConfig(AssemblyConfiguration assemblyConfig, CitrusRemoteAssemblerConfigurationSource source) throws MojoExecutionException {
        Assembly assembly = assemblyConfig.getDescriptor().getInline();
        if (assembly == null) {
            assembly = this.extractAssembly(source);
        }
        return assembly;
    }

    private Assembly extractAssembly(AssemblerConfigurationSource config) throws MojoExecutionException {
        try {
            List assemblies = this.assemblyReader.readAssemblies(config);
            if (assemblies.size() != 1) {
                throw new MojoExecutionException(String.format("Multiple assemblies not supported - found %s assemblies", assemblies.size()));
            }
            return (Assembly)assemblies.get(0);
        }
        catch (AssemblyReadException e) {
            throw new MojoExecutionException("Error reading assembly: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (InvalidAssemblerConfigurationException e) {
            throw new MojoExecutionException((Object)this.assemblyReader, e.getMessage(), "Assembly configuration is invalid: " + e.getMessage());
        }
    }

    public void setAssembly(AssemblyConfiguration assembly) {
        this.assembly = assembly;
    }

    public AssemblyConfiguration getAssembly() {
        if (!this.hasAssemblyConfiguration()) {
            this.initializeAssembly();
        }
        return this.assembly;
    }

    public void setTestJar(TestJarConfiguration testJar) {
        this.testJar = testJar;
    }

    public TestJarConfiguration getTestJar() {
        if (this.testJar == null) {
            this.testJar = new TestJarConfiguration();
            this.testJar.setClassifier("tests");
            this.testJar.setTestClassesDirectory(this.testClassesDirectory);
        }
        return this.testJar;
    }

    public String getFinalName() {
        return this.finalName;
    }
}

