/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin;

import com.consol.citrus.remote.plugin.config.ReportConfiguration;
import com.consol.citrus.remote.plugin.config.ServerConfiguration;
import java.io.File;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.HttpClients;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractCitrusRemoteMojo
extends AbstractMojo {
    @Parameter(property="citrus.remote.plugin.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="citrus.remote.plugin.timeout", defaultValue="60000")
    private int timeout = 60000;
    @Parameter(defaultValue="${project.build.directory}", readonly=true, required=true)
    private File outputDirectory;
    @Parameter
    private ServerConfiguration server;
    @Parameter
    private ReportConfiguration report;
    private final HttpClient httpClient;

    public AbstractCitrusRemoteMojo() {
        this.httpClient = HttpClients.custom().setDefaultRequestConfig(RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setConnectionRequestTimeout(this.timeout).setConnectTimeout(this.timeout).setSocketTimeout(this.timeout).build()).build();
    }

    public AbstractCitrusRemoteMojo(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        this.doExecute();
    }

    public abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public void setServer(ServerConfiguration server) {
        this.server = server;
    }

    public ServerConfiguration getServer() {
        if (this.server == null) {
            this.server = new ServerConfiguration();
        }
        return this.server;
    }

    public void setReport(ReportConfiguration report) {
        this.report = report;
    }

    public ReportConfiguration getReport() {
        if (this.report == null) {
            this.report = new ReportConfiguration();
        }
        return this.report;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }
}

