/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.plugin;

import com.consol.citrus.remote.plugin.AbstractCitrusRemoteMojo;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class VerifyMojo
extends AbstractCitrusRemoteMojo {
    @Parameter(property="citrus.remote.skip.test", defaultValue="false")
    protected boolean skipRun;
    @Parameter(property="citrus.remote.failIfNoTests", defaultValue="true")
    private boolean failIfNoTests = true;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skipRun) {
            return;
        }
        try {
            String summary = FileUtils.readToString((File)new File(this.getOutputDirectory().getPath() + File.separator + this.getReport().getDirectory() + File.separator + this.getReport().getSummaryFile()));
            if (this.failIfNoTests && summary.contains("<completed>0</completed>")) {
                throw new MojoFailureException("No tests were executed! In case you want to allow empty test runs - please set citrus.remote.failIfNoTests property to 'false'.");
            }
            if (!summary.contains("<failures>0</failures>")) {
                throw new MojoFailureException("There are test failures!");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read test report", (Exception)e);
        }
    }

    public boolean isFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }
}

