/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote;

import com.consol.citrus.remote.CitrusRemoteApplication;
import com.consol.citrus.remote.CitrusRemoteConfiguration;
import com.consol.citrus.remote.CitrusRemoteOptions;
import com.consol.citrus.remote.controller.RunController;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Spark;

public class CitrusRemoteServer {
    private static Logger log = LoggerFactory.getLogger(CitrusRemoteServer.class);
    private final CitrusRemoteConfiguration configuration;
    private CitrusRemoteApplication application;
    protected final CompletableFuture<Boolean> completed = new CompletableFuture();

    public CitrusRemoteServer() {
        this(new CitrusRemoteConfiguration());
    }

    public CitrusRemoteServer(CitrusRemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    public CitrusRemoteServer(String[] args) {
        this((CitrusRemoteConfiguration)new CitrusRemoteOptions().apply(new CitrusRemoteConfiguration(), args));
    }

    public static void main(String[] args) {
        CitrusRemoteServer server = new CitrusRemoteServer(args);
        if (server.configuration.getTimeToLive() > 0L) {
            CompletableFuture.runAsync(() -> {
                try {
                    new CompletableFuture().get(server.configuration.getTimeToLive(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    server.stop();
                }
            });
        }
        server.start();
        if (server.configuration.isSystemExit()) {
            if (server.waitForCompletion()) {
                System.exit(0);
            } else {
                System.exit(-1);
            }
        } else {
            server.waitForCompletion();
        }
    }

    public void start() {
        this.application = new CitrusRemoteApplication(this.configuration);
        Spark.port((int)this.configuration.getPort());
        this.application.init();
        if (!this.configuration.isSkipTests()) {
            new RunController(this.configuration).run();
        }
        if (this.configuration.getTimeToLive() == 0L) {
            this.stop();
        }
    }

    public void stop() {
        this.application.destroy();
        this.complete();
        Spark.stop();
    }

    public void complete() {
        this.completed.complete(true);
    }

    public boolean waitForCompletion() {
        try {
            return this.completed.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to wait for server completion", (Throwable)e);
            return false;
        }
    }
}

