/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.controller;

import com.consol.citrus.TestClass;
import com.consol.citrus.main.CitrusApp;
import com.consol.citrus.main.CitrusAppConfiguration;
import com.consol.citrus.remote.CitrusRemoteConfiguration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RunController {
    private String engine;
    private String[] includes;
    private final Map<String, String> defaultProperties = new LinkedHashMap<String, String>();
    private final CitrusRemoteConfiguration configuration;

    public RunController(CitrusRemoteConfiguration configuration) {
        this.configuration = configuration;
        this.engine = configuration.getEngine();
    }

    public void runAll() {
        this.runPackages(Collections.singletonList(""));
    }

    public void runPackages(List<String> packages) {
        CitrusAppConfiguration citrusAppConfiguration = new CitrusAppConfiguration();
        citrusAppConfiguration.setEngine(this.engine);
        citrusAppConfiguration.setIncludes(Optional.ofNullable(this.includes).orElse(this.configuration.getIncludes()));
        citrusAppConfiguration.setPackages(packages);
        citrusAppConfiguration.setConfigClass(this.configuration.getConfigClass());
        citrusAppConfiguration.addDefaultProperties(this.configuration.getDefaultProperties());
        citrusAppConfiguration.addDefaultProperties(this.defaultProperties);
        this.run(citrusAppConfiguration);
    }

    public void runClasses(List<TestClass> testClasses) {
        CitrusAppConfiguration citrusAppConfiguration = new CitrusAppConfiguration();
        citrusAppConfiguration.setEngine(this.engine);
        citrusAppConfiguration.setTestClasses(testClasses);
        citrusAppConfiguration.setConfigClass(this.configuration.getConfigClass());
        citrusAppConfiguration.addDefaultProperties(this.configuration.getDefaultProperties());
        citrusAppConfiguration.addDefaultProperties(this.defaultProperties);
        this.run(citrusAppConfiguration);
    }

    public void run() {
        this.run(this.configuration);
    }

    private void run(CitrusAppConfiguration citrusAppConfiguration) {
        CitrusApp citrusApp = new CitrusApp(citrusAppConfiguration);
        citrusApp.run();
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void addDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties.putAll(defaultProperties);
    }
}

