/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.CitrusInstanceStrategy;
import com.consol.citrus.TestClass;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.main.CitrusAppConfiguration;
import com.consol.citrus.main.TestRunConfiguration;
import com.consol.citrus.remote.CitrusRemoteConfiguration;
import com.consol.citrus.remote.controller.RunController;
import com.consol.citrus.remote.job.RunJob;
import com.consol.citrus.remote.model.RemoteResult;
import com.consol.citrus.remote.reporter.RemoteTestResultReporter;
import com.consol.citrus.remote.transformer.JsonRequestTransformer;
import com.consol.citrus.remote.transformer.JsonResponseTransformer;
import com.consol.citrus.report.JUnitReporter;
import com.consol.citrus.report.LoggingReporter;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import spark.Filter;
import spark.ResponseTransformer;
import spark.Spark;
import spark.servlet.SparkApplication;

public class CitrusRemoteApplication
implements SparkApplication {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusRemoteApplication.class);
    private static final String ENCODING = "UTF-8";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_XML = "application/xml";
    private final CitrusRemoteConfiguration configuration;
    private final ExecutorService jobs = Executors.newSingleThreadExecutor();
    private Future<List<RemoteResult>> remoteResultFuture;
    private final RemoteTestResultReporter remoteTestResultReporter = new RemoteTestResultReporter();
    private final JsonRequestTransformer requestTransformer = new JsonRequestTransformer();
    private final JsonResponseTransformer responseTransformer = new JsonResponseTransformer();

    public CitrusRemoteApplication() {
        this(new CitrusRemoteConfiguration());
    }

    public CitrusRemoteApplication(CitrusRemoteConfiguration configuration) {
        this.configuration = configuration;
    }

    public void init() {
        CitrusInstanceManager.mode((CitrusInstanceStrategy)CitrusInstanceStrategy.SINGLETON);
        CitrusInstanceManager.addInstanceProcessor(citrus -> citrus.addTestReporter((TestReporter)this.remoteTestResultReporter));
        Spark.before((Filter[])new Filter[]{(request, response) -> LOG.info(request.requestMethod() + " " + request.url() + Optional.ofNullable(request.queryString()).map(query -> "?" + query).orElse(""))});
        Spark.get((String)"/health", (req, res) -> {
            res.type(APPLICATION_JSON);
            return "{ \"status\": \"UP\" }";
        });
        Spark.path((String)"/results", () -> {
            Spark.get((String)"", (String)APPLICATION_JSON, (req, res) -> {
                res.type(APPLICATION_JSON);
                long timeout = Optional.ofNullable(req.queryParams("timeout")).map(Long::valueOf).orElse(10000L);
                if (this.remoteResultFuture != null) {
                    try {
                        return this.remoteResultFuture.get(timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        res.status(206);
                    }
                }
                ArrayList results = new ArrayList();
                this.remoteTestResultReporter.getLatestResults().doWithResults(result -> results.add(RemoteResult.fromTestResult(result)));
                return results;
            }, (ResponseTransformer)this.responseTransformer);
            Spark.get((String)"", (req, res) -> this.remoteTestResultReporter.getTestReport());
            Spark.get((String)"/files", (req, res) -> {
                res.type(APPLICATION_JSON);
                File junitReportsFolder = new File(this.getJUnitReportsFolder());
                if (junitReportsFolder.exists()) {
                    return Stream.of(Optional.ofNullable(junitReportsFolder.list()).orElse(new String[0])).collect(Collectors.toList());
                }
                return Collections.emptyList();
            }, (ResponseTransformer)this.responseTransformer);
            Spark.get((String)"/file/:name", (req, res) -> {
                res.type(APPLICATION_XML);
                File junitReportsFolder = new File(this.getJUnitReportsFolder());
                File testResultFile = new File(junitReportsFolder, req.params(":name"));
                if (junitReportsFolder.exists() && testResultFile.exists()) {
                    return FileUtils.readToString((File)testResultFile);
                }
                throw Spark.halt((int)404, (String)("Failed to find test result file: " + req.params(":name")));
            });
            Spark.get((String)"/suite", (req, res) -> {
                res.type(APPLICATION_XML);
                JUnitReporter jUnitReporter = new JUnitReporter();
                File citrusReportsFolder = new File(jUnitReporter.getReportDirectory());
                File suiteResultFile = new File(citrusReportsFolder, String.format(jUnitReporter.getReportFileNamePattern(), jUnitReporter.getSuiteName()));
                if (citrusReportsFolder.exists() && suiteResultFile.exists()) {
                    return FileUtils.readToString((File)suiteResultFile);
                }
                throw Spark.halt((int)404, (String)("Failed to find suite result file: " + suiteResultFile.getPath()));
            });
        });
        Spark.path((String)"/run", () -> {
            Spark.get((String)"", (req, res) -> {
                TestRunConfiguration runConfiguration = new TestRunConfiguration();
                if (req.queryParams().contains("engine")) {
                    runConfiguration.setEngine(URLDecoder.decode(req.queryParams("engine"), ENCODING));
                } else {
                    runConfiguration.setEngine(this.configuration.getEngine());
                }
                if (req.queryParams().contains("includes")) {
                    runConfiguration.setIncludes(StringUtils.commaDelimitedListToStringArray((String)URLDecoder.decode(req.queryParams("includes"), ENCODING)));
                }
                if (req.queryParams().contains("package")) {
                    runConfiguration.setPackages(Collections.singletonList(URLDecoder.decode(req.queryParams("package"), ENCODING)));
                }
                if (req.queryParams().contains("class")) {
                    runConfiguration.setTestClasses(Collections.singletonList(TestClass.fromString((String)URLDecoder.decode(req.queryParams("class"), ENCODING))));
                }
                res.type(APPLICATION_JSON);
                return this.runTests(runConfiguration);
            }, (ResponseTransformer)this.responseTransformer);
            Spark.put((String)"", (req, res) -> {
                this.remoteResultFuture = this.jobs.submit(new RunJob(this.requestTransformer.read(req.body(), TestRunConfiguration.class)){

                    @Override
                    public List<RemoteResult> run(TestRunConfiguration runConfiguration) {
                        return CitrusRemoteApplication.this.runTests(runConfiguration);
                    }
                });
                return "";
            });
            Spark.post((String)"", (req, res) -> {
                TestRunConfiguration runConfiguration = this.requestTransformer.read(req.body(), TestRunConfiguration.class);
                return this.runTests(runConfiguration);
            }, (ResponseTransformer)this.responseTransformer);
        });
        Spark.path((String)"/configuration", () -> {
            Spark.get((String)"", (req, res) -> {
                res.type(APPLICATION_JSON);
                return this.configuration;
            }, (ResponseTransformer)this.responseTransformer);
            Spark.put((String)"", (req, res) -> {
                this.configuration.apply(this.requestTransformer.read(req.body(), CitrusAppConfiguration.class));
                return "";
            });
        });
        Spark.exception(CitrusRuntimeException.class, (exception, request, response) -> {
            response.status(500);
            response.body(exception.getMessage());
        });
    }

    private List<RemoteResult> runTests(TestRunConfiguration runConfiguration) {
        RunController runController = new RunController(this.configuration);
        runController.setEngine(runConfiguration.getEngine());
        runController.setIncludes(runConfiguration.getIncludes());
        if (!CollectionUtils.isEmpty((Map)runConfiguration.getDefaultProperties())) {
            runController.addDefaultProperties(runConfiguration.getDefaultProperties());
        }
        if (CollectionUtils.isEmpty((Collection)runConfiguration.getPackages()) && CollectionUtils.isEmpty((Collection)runConfiguration.getTestClasses())) {
            runController.runAll();
        }
        if (!CollectionUtils.isEmpty((Collection)runConfiguration.getPackages())) {
            runController.runPackages(runConfiguration.getPackages());
        }
        if (!CollectionUtils.isEmpty((Collection)runConfiguration.getTestClasses())) {
            runController.runClasses(runConfiguration.getTestClasses());
        }
        ArrayList<RemoteResult> results = new ArrayList<RemoteResult>();
        this.remoteTestResultReporter.getLatestResults().doWithResults(result -> results.add(RemoteResult.fromTestResult(result)));
        return results;
    }

    private String getJUnitReportsFolder() {
        if (ClassUtils.isPresent((String)"org.testng.annotations.Test", (ClassLoader)this.getClass().getClassLoader())) {
            return "test-output" + File.separator + "junitreports";
        }
        if (ClassUtils.isPresent((String)"org.junit.Test", (ClassLoader)this.getClass().getClassLoader())) {
            JUnitReporter jUnitReporter = new JUnitReporter();
            return jUnitReporter.getReportDirectory() + File.separator + jUnitReporter.getOutputDirectory();
        }
        return new LoggingReporter().getReportDirectory();
    }

    public void destroy() {
        Optional citrus = CitrusInstanceManager.get();
        if (citrus.isPresent()) {
            LOG.info("Closing Citrus and its application context");
            ((Citrus)citrus.get()).close();
        }
    }
}

