/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.model;

import com.consol.citrus.TestResult;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;

public class RemoteResult {
    private String testName;
    private String testClass;
    private String cause;
    private String errorMessage;
    private String failureStack;
    private boolean success;
    private boolean failed;
    private boolean skipped;

    public static RemoteResult fromTestResult(TestResult testResult) {
        RemoteResult remoteResult = new RemoteResult();
        remoteResult.setTestName(testResult.getTestName());
        remoteResult.setTestClass(testResult.getClassName());
        remoteResult.setSuccess(testResult.isSuccess());
        remoteResult.setFailed(testResult.isFailed());
        remoteResult.setSkipped(testResult.isSkipped());
        if (testResult.isFailed()) {
            Optional.ofNullable(testResult.getCause()).ifPresent(cause -> {
                remoteResult.setCause(cause.getClass().getName());
                remoteResult.setErrorMessage(cause.getMessage());
                StringWriter stackWriter = new StringWriter();
                cause.printStackTrace(new PrintWriter(stackWriter));
                remoteResult.setFailureStack(stackWriter.toString());
            });
        }
        return remoteResult;
    }

    public static TestResult toTestResult(RemoteResult remoteResult) {
        if (remoteResult.isSuccess()) {
            return TestResult.success((String)remoteResult.getTestName(), (String)remoteResult.getTestClass());
        }
        if (remoteResult.isSkipped()) {
            return TestResult.skipped((String)remoteResult.getTestName(), (String)remoteResult.getTestClass());
        }
        if (remoteResult.isFailed()) {
            return TestResult.failed((String)remoteResult.getTestName(), (String)remoteResult.getTestClass(), (String)remoteResult.getErrorMessage()).withFailureType(remoteResult.getCause()).withFailureStack(remoteResult.getFailureStack());
        }
        throw new CitrusRuntimeException("Unexpected test result state " + remoteResult.getTestName());
    }

    public String getTestName() {
        return this.testName;
    }

    public void setTestName(String testName) {
        this.testName = testName;
    }

    public String getTestClass() {
        return this.testClass;
    }

    public void setTestClass(String testClass) {
        this.testClass = testClass;
    }

    public String getCause() {
        return this.cause;
    }

    public void setCause(String cause) {
        this.cause = cause;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFailureStack() {
        return this.failureStack;
    }

    public void setFailureStack(String failureStack) {
        this.failureStack = failureStack;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }
}

