/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.remote.transformer;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import spark.ResponseTransformer;

public class JsonResponseTransformer
implements ResponseTransformer {
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonResponseTransformer() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public String render(Object model) {
        try {
            return this.mapper.writeValueAsString(model);
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to write json test results", (Throwable)e);
        }
    }
}

