/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Consumer;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.selenium.actions.SeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowserConfiguration;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class SeleniumBrowser
extends AbstractEndpoint
implements Producer {
    private static Logger log = LoggerFactory.getLogger(SeleniumBrowser.class);
    private WebDriver webDriver;
    private Path temporaryStorage = this.createTemporaryStorage();

    public SeleniumBrowser() {
        this(new SeleniumBrowserConfiguration());
    }

    public SeleniumBrowser(SeleniumBrowserConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public void send(Message message, TestContext context) {
        SeleniumAction action = (SeleniumAction)message.getPayload(SeleniumAction.class);
        action.execute(context);
        log.info("Selenium action successfully executed");
    }

    public void start() {
        if (!this.isStarted()) {
            this.webDriver = this.getEndpointConfiguration().getWebDriver() != null ? this.getEndpointConfiguration().getWebDriver() : (StringUtils.hasText((String)this.getEndpointConfiguration().getRemoteServerUrl()) ? this.createRemoteWebDriver(this.getEndpointConfiguration().getBrowserType(), this.getEndpointConfiguration().getRemoteServerUrl()) : this.createLocalWebDriver(this.getEndpointConfiguration().getBrowserType()));
            if (!CollectionUtils.isEmpty(this.getEndpointConfiguration().getEventListeners())) {
                EventFiringWebDriver wrapper = new EventFiringWebDriver(this.webDriver);
                log.info("Add event listeners to web driver: " + this.getEndpointConfiguration().getEventListeners().size());
                for (WebDriverEventListener listener : this.getEndpointConfiguration().getEventListeners()) {
                    wrapper.register(listener);
                }
            }
        } else {
            log.debug("Browser already started");
        }
    }

    public void stop() {
        if (this.isStarted()) {
            log.info("Stopping browser " + this.webDriver.getCurrentUrl());
            try {
                log.info("Trying to close the browser " + this.webDriver + " ...");
                this.webDriver.quit();
            }
            catch (UnreachableBrowserException e) {
                log.warn("Browser is unreachable", (Throwable)e);
            }
            catch (WebDriverException e) {
                log.error("Failed to close browser", (Throwable)e);
            }
            this.webDriver = null;
        } else {
            log.warn("Browser already stopped");
        }
    }

    public String storeFile(String fileLocation) {
        return this.storeFile(new PathMatchingResourcePatternResolver().getResource(fileLocation));
    }

    public String storeFile(Resource file) {
        try {
            File newFile = new File(this.temporaryStorage.toFile(), file.getFilename());
            log.info("Store file " + file + " to " + newFile);
            FileUtils.copyFile((File)file.getFile(), (File)newFile);
            return newFile.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to store file: " + file, (Throwable)e);
        }
    }

    public String getStoredFile(String filename) {
        try {
            File stored = new File(this.temporaryStorage.toFile(), filename);
            if (!stored.exists()) {
                throw new CitrusRuntimeException("Failed to access stored file: " + stored.getCanonicalPath());
            }
            return stored.getCanonicalPath();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to retrieve file: " + filename, (Throwable)e);
        }
    }

    private WebDriver createLocalWebDriver(String browserType) {
        switch (browserType) {
            case "firefox": {
                FirefoxProfile firefoxProfile = this.getEndpointConfiguration().getFirefoxProfile();
                firefoxProfile.setPreference("browser.download.dir", this.temporaryStorage.toFile().getAbsolutePath());
                DesiredCapabilities defaults = DesiredCapabilities.firefox();
                defaults.setCapability("firefox_profile", (Object)firefoxProfile);
                return new FirefoxDriver((Capabilities)defaults);
            }
            case "internet explorer": {
                return new InternetExplorerDriver();
            }
            case "MicrosoftEdge": {
                return new EdgeDriver();
            }
            case "safari": {
                return new SafariDriver();
            }
            case "chrome": {
                return new ChromeDriver();
            }
            case "googlechrome": {
                return new ChromeDriver();
            }
            case "htmlunit": {
                BrowserVersion browserVersion = null;
                if (this.getEndpointConfiguration().getVersion().equals("FIREFOX")) {
                    browserVersion = BrowserVersion.FIREFOX;
                } else if (this.getEndpointConfiguration().getVersion().equals("FIREFOX_60")) {
                    browserVersion = BrowserVersion.FIREFOX_60;
                } else if (this.getEndpointConfiguration().getVersion().equals("FIREFOX_68")) {
                    browserVersion = BrowserVersion.FIREFOX_68;
                } else if (this.getEndpointConfiguration().getVersion().equals("INTERNET_EXPLORER")) {
                    browserVersion = BrowserVersion.INTERNET_EXPLORER;
                } else if (this.getEndpointConfiguration().getVersion().equals("CHROME")) {
                    browserVersion = BrowserVersion.CHROME;
                }
                HtmlUnitDriver htmlUnitDriver = browserVersion != null ? new HtmlUnitDriver(browserVersion, this.getEndpointConfiguration().isJavaScript()) : new HtmlUnitDriver(this.getEndpointConfiguration().isJavaScript());
                return htmlUnitDriver;
            }
        }
        throw new CitrusRuntimeException("Unsupported local browser type: " + browserType);
    }

    private RemoteWebDriver createRemoteWebDriver(String browserType, String serverAddress) {
        try {
            switch (browserType) {
                case "firefox": {
                    DesiredCapabilities defaultsFF = DesiredCapabilities.firefox();
                    defaultsFF.setCapability("firefox_profile", (Object)this.getEndpointConfiguration().getFirefoxProfile());
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)defaultsFF);
                }
                case "internet explorer": {
                    DesiredCapabilities defaultsIE = DesiredCapabilities.internetExplorer();
                    defaultsIE.setCapability("acceptSslCerts", true);
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)defaultsIE);
                }
                case "chrome": {
                    DesiredCapabilities defaultsChrome = DesiredCapabilities.chrome();
                    defaultsChrome.setCapability("acceptSslCerts", true);
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)defaultsChrome);
                }
                case "googlechrome": {
                    DesiredCapabilities defaultsGoogleChrome = DesiredCapabilities.chrome();
                    defaultsGoogleChrome.setCapability("acceptSslCerts", true);
                    return new RemoteWebDriver(new URL(serverAddress), (Capabilities)defaultsGoogleChrome);
                }
            }
            throw new CitrusRuntimeException("Unsupported remote browser type: " + browserType);
        }
        catch (MalformedURLException e) {
            throw new CitrusRuntimeException("Failed to access remote server", (Throwable)e);
        }
    }

    private Path createTemporaryStorage() {
        try {
            Path tempDir = Files.createTempDirectory("selenium", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            log.info("Download storage location is: " + tempDir.toString());
            return tempDir;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Could not create temporary storage", (Throwable)e);
        }
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setWebDriver(WebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public boolean isStarted() {
        return this.webDriver != null;
    }

    public SeleniumBrowserConfiguration getEndpointConfiguration() {
        return (SeleniumBrowserConfiguration)super.getEndpointConfiguration();
    }

    public Producer createProducer() {
        return this;
    }

    public Consumer createConsumer() {
        throw new UnsupportedOperationException("Selenium browser must not be used as message consumer");
    }
}

