/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.SeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSeleniumAction
extends AbstractTestAction
implements SeleniumAction {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private final SeleniumBrowser browser;

    public AbstractSeleniumAction(String name, Builder<?, ?> builder) {
        super("selenium:" + name, builder);
        this.browser = builder.browser;
    }

    public void doExecute(TestContext context) {
        SeleniumBrowser browserToUse;
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Executing Selenium browser command '%s'", this.getName()));
        }
        if ((browserToUse = this.browser) == null) {
            if (context.getVariables().containsKey("selenium_browser")) {
                browserToUse = (SeleniumBrowser)((Object)context.getReferenceResolver().resolve(context.getVariable("selenium_browser"), SeleniumBrowser.class));
            } else {
                throw new CitrusRuntimeException("Failed to get active browser instance, either set explicit browser for action or start browser instance");
            }
        }
        this.execute(browserToUse, context);
        this.log.info(String.format("Selenium browser command execution successful: '%s'", this.getName()));
    }

    protected abstract void execute(SeleniumBrowser var1, TestContext var2);

    @Override
    public SeleniumBrowser getBrowser() {
        return this.browser;
    }

    public static abstract class Builder<T extends SeleniumAction, B extends Builder<T, B>>
    extends AbstractTestActionBuilder<T, B> {
        private SeleniumBrowser browser;

        public B browser(SeleniumBrowser seleniumBrowser) {
            this.browser = seleniumBrowser;
            return (B)((Object)((Builder)this.self));
        }
    }
}

