/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriverException;

public class JavaScriptAction
extends AbstractSeleniumAction {
    private final String script;
    private final List<Object> arguments;
    private final List<String> expectedErrors;

    public JavaScriptAction(Builder builder) {
        super("javascript", builder);
        this.script = builder.script;
        this.arguments = builder.arguments;
        this.expectedErrors = builder.expectedErrors;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        try {
            if (browser.getWebDriver() instanceof JavascriptExecutor) {
                JavascriptExecutor jsEngine = (JavascriptExecutor)browser.getWebDriver();
                jsEngine.executeScript(context.replaceDynamicContentInString(this.script), context.resolveDynamicValuesInArray(this.arguments.toArray()));
                ArrayList<String> errors = new ArrayList<String>();
                List errorObjects = (List)jsEngine.executeScript("return window._selenide_jsErrors", new Object[0]);
                if (errorObjects != null) {
                    for (Object error : errorObjects) {
                        errors.add(error.toString());
                    }
                }
                context.setVariable("selenium_js_errors", errors);
                for (String expected : this.expectedErrors) {
                    if (errors.contains(expected)) continue;
                    throw new ValidationException("Missing JavaScript error " + expected);
                }
            } else {
                this.log.warn("Skip javascript action because web driver is missing javascript features");
            }
        }
        catch (WebDriverException e) {
            throw new CitrusRuntimeException("Failed to execute JavaScript code", (Throwable)e);
        }
    }

    public String getScript() {
        return this.script;
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public List<String> getExpectedErrors() {
        return this.expectedErrors;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<JavaScriptAction, Builder> {
        private String script;
        private List<Object> arguments = new ArrayList<Object>();
        private List<String> expectedErrors = new ArrayList<String>();

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder argument(Object arg) {
            this.arguments.add(arg);
            return this;
        }

        public Builder errors(String ... errors) {
            return this.errors(Arrays.asList(errors));
        }

        public Builder errors(List<String> errors) {
            this.expectedErrors.addAll(errors);
            return this;
        }

        public JavaScriptAction build() {
            return new JavaScriptAction(this);
        }
    }
}

