/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class MakeScreenshotAction
extends AbstractSeleniumAction {
    private final String outputDir;

    public MakeScreenshotAction(Builder builder) {
        super("screenshot", builder);
        this.outputDir = builder.outputDir;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        File screenshot = null;
        if (browser.getWebDriver() instanceof TakesScreenshot) {
            screenshot = (File)((TakesScreenshot)browser.getWebDriver()).getScreenshotAs(OutputType.FILE);
        } else {
            this.log.warn("Skip screenshot action because web driver is missing screenshot features");
        }
        if (screenshot != null) {
            String testName = "Test";
            if (context.getVariables().containsKey(CitrusSettings.TEST_NAME_VARIABLE)) {
                testName = context.getVariable(CitrusSettings.TEST_NAME_VARIABLE);
            }
            context.setVariable("selenium_screenshot", (Object)(testName + "_" + screenshot.getName()));
            if (StringUtils.hasText((String)this.outputDir)) {
                try {
                    File targetDir = new File(context.replaceDynamicContentInString(this.outputDir));
                    if (!targetDir.exists() && !targetDir.mkdirs()) {
                        throw new CitrusRuntimeException("Failed to create screenshot output directory: " + this.outputDir);
                    }
                    FileCopyUtils.copy((File)screenshot, (File)new File(targetDir, testName + "_" + screenshot.getName()));
                }
                catch (IOException e) {
                    this.log.error("Failed to save screenshot to target storage", (Throwable)e);
                }
            } else {
                browser.storeFile((Resource)new FileSystemResource(screenshot));
            }
        }
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<MakeScreenshotAction, Builder> {
        private String outputDir;

        public Builder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public MakeScreenshotAction build() {
            return new MakeScreenshotAction(this);
        }
    }
}

