/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.util.BrowserUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import org.springframework.util.StringUtils;

public class NavigateAction
extends AbstractSeleniumAction {
    private final String page;

    public NavigateAction(Builder builder) {
        super("navigate", builder);
        this.page = builder.page;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (this.page.equals("back")) {
            browser.getWebDriver().navigate().back();
        } else if (this.page.equals("forward")) {
            browser.getWebDriver().navigate().forward();
        } else if (this.page.equals("refresh")) {
            browser.getWebDriver().navigate().refresh();
        } else {
            try {
                if (browser.getEndpointConfiguration().getBrowserType().equals("internet explorer")) {
                    String cachingSafeUrl = BrowserUtils.makeIECachingSafeUrl(context.replaceDynamicContentInString(this.page), new Date().getTime());
                    browser.getWebDriver().navigate().to(new URL(cachingSafeUrl));
                } else {
                    browser.getWebDriver().navigate().to(new URL(context.replaceDynamicContentInString(this.page)));
                }
            }
            catch (MalformedURLException ex) {
                Object baseUrl;
                block14: {
                    baseUrl = browser.getWebDriver().getCurrentUrl();
                    try {
                        new URL((String)baseUrl);
                    }
                    catch (MalformedURLException e) {
                        if (StringUtils.hasText((String)browser.getEndpointConfiguration().getStartPageUrl())) {
                            baseUrl = browser.getEndpointConfiguration().getStartPageUrl();
                            break block14;
                        }
                        throw new CitrusRuntimeException("Failed to create relative page URL - must set start page on browser", (Throwable)ex);
                    }
                }
                String lastChar = ((String)baseUrl).substring(((String)baseUrl).length() - 1);
                if (!lastChar.equals("/")) {
                    baseUrl = (String)baseUrl + "/";
                }
                browser.getWebDriver().navigate().to((String)baseUrl + context.replaceDynamicContentInString(this.page));
            }
        }
    }

    public String getPage() {
        return this.page;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<NavigateAction, Builder> {
        private String page;

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public NavigateAction build() {
            return new NavigateAction(this);
        }
    }
}

