/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;

public class GetStoredFileAction
extends AbstractSeleniumAction {
    private final String fileName;

    public GetStoredFileAction(Builder builder) {
        super("get-stored-file", builder);
        this.fileName = builder.fileName;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        String filePath = browser.getStoredFile(context.replaceDynamicContentInString(this.fileName));
        context.setVariable("selenium_download_file", (Object)filePath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<GetStoredFileAction, Builder> {
        private String fileName;

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public GetStoredFileAction build() {
            return new GetStoredFileAction(this);
        }
    }
}

