/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.model.PageValidator;
import com.consol.citrus.selenium.model.WebPage;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.PageFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class PageAction
extends AbstractSeleniumAction {
    private final WebPage page;
    private final String type;
    private final String action;
    private final List<String> arguments;
    private final PageValidator validator;

    public PageAction(Builder builder) {
        super("page", builder);
        this.page = builder.page;
        this.type = builder.type;
        this.action = builder.action;
        this.arguments = builder.arguments;
        this.validator = builder.validator;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        WebPage pageToUse;
        if (StringUtils.hasText((String)this.type)) {
            try {
                pageToUse = (WebPage)Class.forName(context.replaceDynamicContentInString(this.type)).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new CitrusRuntimeException(String.format("Failed to access page type '%s'", context.replaceDynamicContentInString(this.type)), (Throwable)e);
            }
        } else {
            pageToUse = this.page;
        }
        PageFactory.initElements((WebDriver)browser.getWebDriver(), (Object)pageToUse);
        if (StringUtils.hasText((String)this.action)) {
            if (this.action.equals("validate") && (this.validator != null || pageToUse instanceof PageValidator)) {
                if (this.validator != null) {
                    this.validator.validate(pageToUse, browser, context);
                }
                if (pageToUse instanceof PageValidator) {
                    ((PageValidator)((Object)pageToUse)).validate(pageToUse, browser, context);
                }
            } else {
                ReflectionUtils.doWithMethods(pageToUse.getClass(), method -> {
                    if (method.getName().equals(this.action)) {
                        if (method.getParameterCount() == 0 && this.arguments.size() == 0) {
                            ReflectionUtils.invokeMethod((Method)method, (Object)pageToUse);
                        } else if (method.getParameterCount() == 1 && method.getParameters()[0].getParameterizedType().getTypeName().equals(TestContext.class.getName())) {
                            ReflectionUtils.invokeMethod((Method)method, (Object)pageToUse, (Object[])new Object[]{context});
                        } else if (method.getParameterCount() == this.arguments.size()) {
                            ReflectionUtils.invokeMethod((Method)method, (Object)pageToUse, (Object[])context.resolveDynamicValuesInList(this.arguments).toArray());
                        } else if (method.getParameterCount() == this.arguments.size() + 1) {
                            Object[] args = Arrays.copyOf(this.arguments.toArray(), this.arguments.size() + 1);
                            args[this.arguments.size()] = context;
                            ReflectionUtils.invokeMethod((Method)method, (Object)pageToUse, (Object[])context.resolveDynamicValuesInArray(args));
                        } else {
                            throw new CitrusRuntimeException("Unsupported method signature for page action - not matching given arguments");
                        }
                    }
                });
            }
        }
    }

    public WebPage getPage() {
        return this.page;
    }

    public String getAction() {
        return this.action;
    }

    public PageValidator getValidator() {
        return this.validator;
    }

    public String getType() {
        return this.type;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<PageAction, Builder> {
        private WebPage page;
        private String type;
        private String action;
        private List<String> arguments = new ArrayList<String>();
        private PageValidator validator;

        public Builder page(WebPage page) {
            this.page = page;
            return this;
        }

        public Builder type(String pageType) {
            this.type = pageType;
            return this;
        }

        public Builder type(Class<? extends WebPage> pageType) {
            this.type = pageType.getName();
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder validate() {
            this.action = "validate";
            return this;
        }

        public Builder validator(PageValidator validator) {
            this.validator = validator;
            return this;
        }

        public Builder execute(String method) {
            this.action = method;
            return this;
        }

        public Builder argument(String arg) {
            this.arguments.add(arg);
            return this;
        }

        public Builder arguments(String ... args) {
            return this.arguments(Arrays.asList(args));
        }

        public Builder arguments(List<String> args) {
            this.arguments.addAll(args);
            return this;
        }

        public PageAction build() {
            return new PageAction(this);
        }
    }
}

