/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.actions.SeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import java.util.Set;

public class CloseWindowAction
extends AbstractSeleniumAction
implements SeleniumAction {
    private final String windowName;

    public CloseWindowAction(Builder builder) {
        super("close-window", builder);
        this.windowName = builder.windowName;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        if (!context.getVariables().containsKey(this.windowName)) {
            throw new CitrusRuntimeException("Failed to find window handle for window " + this.windowName);
        }
        Set handles = browser.getWebDriver().getWindowHandles();
        if (!handles.contains(context.getVariable(this.windowName))) {
            throw new CitrusRuntimeException("Failed to find window for handle " + context.getVariable(this.windowName));
        }
        this.log.info("Current window: " + browser.getWebDriver().getWindowHandle());
        this.log.info("Window to close: " + context.getVariable(this.windowName));
        if (browser.getWebDriver().getWindowHandle().equals(context.getVariable(this.windowName))) {
            browser.getWebDriver().close();
            this.log.info("Switch back to main window!");
            if (context.getVariables().containsKey("selenium_last_window")) {
                browser.getWebDriver().switchTo().window(context.getVariable("selenium_last_window"));
                context.setVariable("selenium_active_window", (Object)context.getVariable("selenium_last_window"));
            } else {
                browser.getWebDriver().switchTo().defaultContent();
                context.setVariable("selenium_active_window", (Object)browser.getWebDriver().getWindowHandle());
            }
        } else {
            String activeWindow = browser.getWebDriver().getWindowHandle();
            browser.getWebDriver().switchTo().window(context.getVariable(this.windowName));
            browser.getWebDriver().close();
            if (context.getVariables().containsKey("selenium_active_window")) {
                browser.getWebDriver().switchTo().window(context.getVariable("selenium_active_window"));
            } else {
                browser.getWebDriver().switchTo().window(activeWindow);
                context.setVariable("selenium_active_window", (Object)activeWindow);
            }
        }
    }

    public String getWindowName() {
        return this.windowName;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<CloseWindowAction, Builder> {
        private String windowName = "selenium_active_window";

        public Builder window(String name) {
            this.windowName = name;
            return this;
        }

        public CloseWindowAction build() {
            return new CloseWindowAction(this);
        }
    }
}

