/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.actions.AlertAction;
import com.consol.citrus.selenium.actions.CheckInputAction;
import com.consol.citrus.selenium.actions.ClearBrowserCacheAction;
import com.consol.citrus.selenium.actions.ClickAction;
import com.consol.citrus.selenium.actions.CloseWindowAction;
import com.consol.citrus.selenium.actions.DropDownSelectAction;
import com.consol.citrus.selenium.actions.FindElementAction;
import com.consol.citrus.selenium.actions.GetStoredFileAction;
import com.consol.citrus.selenium.actions.HoverAction;
import com.consol.citrus.selenium.actions.JavaScriptAction;
import com.consol.citrus.selenium.actions.MakeScreenshotAction;
import com.consol.citrus.selenium.actions.NavigateAction;
import com.consol.citrus.selenium.actions.OpenWindowAction;
import com.consol.citrus.selenium.actions.PageAction;
import com.consol.citrus.selenium.actions.SeleniumAction;
import com.consol.citrus.selenium.actions.SetInputAction;
import com.consol.citrus.selenium.actions.StartBrowserAction;
import com.consol.citrus.selenium.actions.StopBrowserAction;
import com.consol.citrus.selenium.actions.StoreFileAction;
import com.consol.citrus.selenium.actions.SwitchWindowAction;
import com.consol.citrus.selenium.actions.WaitUntilAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.selenium.model.WebPage;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SeleniumActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<SeleniumAction> {
    private SeleniumBrowser seleniumBrowser;
    private AbstractSeleniumAction.Builder<? extends SeleniumAction, ?> delegate;

    public static SeleniumActionBuilder selenium() {
        return new SeleniumActionBuilder();
    }

    public SeleniumActionBuilder browser(SeleniumBrowser seleniumBrowser) {
        this.seleniumBrowser = seleniumBrowser;
        return this;
    }

    public StartBrowserAction.Builder start() {
        StartBrowserAction.Builder builder;
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StartBrowserAction.Builder start(SeleniumBrowser seleniumBrowser) {
        StartBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StartBrowserAction.Builder)((Object)new StartBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop() {
        StopBrowserAction.Builder builder;
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public StopBrowserAction.Builder stop(SeleniumBrowser seleniumBrowser) {
        StopBrowserAction.Builder builder;
        this.browser(seleniumBrowser);
        this.delegate = builder = (StopBrowserAction.Builder)((Object)new StopBrowserAction.Builder().browser(seleniumBrowser));
        return builder;
    }

    public AlertAction.Builder alert() {
        AlertAction.Builder builder;
        this.delegate = builder = (AlertAction.Builder)((Object)new AlertAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public NavigateAction.Builder navigate(String page) {
        NavigateAction.Builder builder;
        this.delegate = builder = (NavigateAction.Builder)((Object)new NavigateAction.Builder().page(page).browser(this.seleniumBrowser));
        return builder;
    }

    public PageAction.Builder page(WebPage page) {
        PageAction.Builder builder;
        this.delegate = builder = (PageAction.Builder)((Object)new PageAction.Builder().page(page).browser(this.seleniumBrowser));
        return builder;
    }

    public PageAction.Builder page(Class<? extends WebPage> pageType) {
        PageAction.Builder builder;
        this.delegate = builder = (PageAction.Builder)((Object)new PageAction.Builder().type(pageType).browser(this.seleniumBrowser));
        return builder;
    }

    public FindElementAction.Builder find() {
        FindElementAction.Builder builder;
        this.delegate = builder = (FindElementAction.Builder)((Object)new FindElementAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public DropDownSelectAction.Builder select(String option) {
        DropDownSelectAction.Builder builder;
        this.delegate = builder = (DropDownSelectAction.Builder)((Object)new DropDownSelectAction.Builder().option(option).browser(this.seleniumBrowser));
        return builder;
    }

    public DropDownSelectAction.Builder select(String ... options) {
        DropDownSelectAction.Builder builder;
        this.delegate = builder = (DropDownSelectAction.Builder)((Object)new DropDownSelectAction.Builder().options(options).browser(this.seleniumBrowser));
        return builder;
    }

    public SetInputAction.Builder setInput(String value) {
        SetInputAction.Builder builder;
        this.delegate = builder = (SetInputAction.Builder)((Object)new SetInputAction.Builder().value(value).browser(this.seleniumBrowser));
        return builder;
    }

    public CheckInputAction.Builder checkInput(boolean checked) {
        CheckInputAction.Builder builder;
        this.delegate = builder = (CheckInputAction.Builder)((Object)new CheckInputAction.Builder().checked(checked).browser(this.seleniumBrowser));
        return builder;
    }

    public ClickAction.Builder click() {
        ClickAction.Builder builder;
        this.delegate = builder = (ClickAction.Builder)((Object)new ClickAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public HoverAction.Builder hover() {
        HoverAction.Builder builder;
        this.delegate = builder = (HoverAction.Builder)((Object)new HoverAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public ClearBrowserCacheAction.Builder clearCache() {
        ClearBrowserCacheAction.Builder builder;
        this.delegate = builder = (ClearBrowserCacheAction.Builder)((Object)new ClearBrowserCacheAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public MakeScreenshotAction.Builder screenshot() {
        MakeScreenshotAction.Builder builder;
        this.delegate = builder = (MakeScreenshotAction.Builder)((Object)new MakeScreenshotAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public MakeScreenshotAction.Builder screenshot(String outputDir) {
        MakeScreenshotAction.Builder builder;
        this.delegate = builder = (MakeScreenshotAction.Builder)((Object)new MakeScreenshotAction.Builder().outputDir(outputDir).browser(this.seleniumBrowser));
        return builder;
    }

    public StoreFileAction.Builder store(String filePath) {
        StoreFileAction.Builder builder;
        this.delegate = builder = (StoreFileAction.Builder)((Object)new StoreFileAction.Builder().filePath(filePath).browser(this.seleniumBrowser));
        return builder;
    }

    public GetStoredFileAction.Builder getStored(String fileName) {
        GetStoredFileAction.Builder builder;
        this.delegate = builder = (GetStoredFileAction.Builder)((Object)new GetStoredFileAction.Builder().fileName(fileName).browser(this.seleniumBrowser));
        return builder;
    }

    public WaitUntilAction.Builder waitUntil() {
        WaitUntilAction.Builder builder;
        this.delegate = builder = (WaitUntilAction.Builder)((Object)new WaitUntilAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript(String script) {
        JavaScriptAction.Builder builder;
        this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().script(script).browser(this.seleniumBrowser));
        return builder;
    }

    public JavaScriptAction.Builder javascript(Resource script) {
        return this.javascript(script, FileUtils.getDefaultCharset());
    }

    public JavaScriptAction.Builder javascript(Resource scriptResource, Charset charset) {
        try {
            JavaScriptAction.Builder builder;
            this.delegate = builder = (JavaScriptAction.Builder)((Object)new JavaScriptAction.Builder().script(FileUtils.readToString((Resource)scriptResource, (Charset)charset)).browser(this.seleniumBrowser));
            return builder;
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource", (Throwable)e);
        }
    }

    public OpenWindowAction.Builder open() {
        OpenWindowAction.Builder builder;
        this.delegate = builder = (OpenWindowAction.Builder)((Object)new OpenWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public CloseWindowAction.Builder close() {
        CloseWindowAction.Builder builder;
        this.delegate = builder = (CloseWindowAction.Builder)((Object)new CloseWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SwitchWindowAction.Builder focus() {
        SwitchWindowAction.Builder builder;
        this.delegate = builder = (SwitchWindowAction.Builder)((Object)new SwitchWindowAction.Builder().browser(this.seleniumBrowser));
        return builder;
    }

    public SeleniumAction build() {
        Assert.notNull(this.delegate, (String)"Missing delegate action to build");
        if (this.seleniumBrowser != null) {
            this.delegate.browser(this.seleniumBrowser);
        }
        return (SeleniumAction)this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }
}

