/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;

public class StoreFileAction
extends AbstractSeleniumAction {
    private final String filePath;

    public StoreFileAction(Builder builder) {
        super("store-file", builder);
        this.filePath = builder.filePath;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        browser.storeFile(context.replaceDynamicContentInString(this.filePath));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<StoreFileAction, Builder> {
        private String filePath;

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public StoreFileAction build() {
            return new StoreFileAction(this);
        }
    }
}

