/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.actions;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.selenium.actions.AbstractSeleniumAction;
import com.consol.citrus.selenium.endpoint.SeleniumBrowser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import org.openqa.selenium.Alert;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AlertAction
extends AbstractSeleniumAction {
    private final boolean accept;
    private final String text;

    public AlertAction(Builder builder) {
        super("alert", builder);
        this.accept = builder.accept;
        this.text = builder.text;
    }

    @Override
    protected void execute(SeleniumBrowser browser, TestContext context) {
        Alert alert = browser.getWebDriver().switchTo().alert();
        if (alert == null) {
            throw new CitrusRuntimeException("Failed to access alert dialog - not found");
        }
        if (StringUtils.hasText((String)this.text)) {
            this.log.info("Validating alert text");
            String alertText = context.replaceDynamicContentInString(this.text);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)alertText)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"alertText", (String)alert.getText(), (String)alertText, (TestContext)context);
            } else {
                Assert.isTrue((boolean)alertText.equals(alert.getText()), (String)String.format("Failed to validate alert dialog text, expected '%s', but was '%s'", alertText, alert.getText()));
            }
            this.log.info("Alert text validation successful - All values Ok");
        }
        context.setVariable("selenium_alert_text", (Object)alert.getText());
        if (this.accept) {
            alert.accept();
        } else {
            alert.dismiss();
        }
    }

    public boolean isAccept() {
        return this.accept;
    }

    public String getText() {
        return this.text;
    }

    public static class Builder
    extends AbstractSeleniumAction.Builder<AlertAction, Builder> {
        private boolean accept = true;
        private String text;

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder accept() {
            this.accept = true;
            return this;
        }

        public Builder dismiss() {
            this.accept = false;
            return this;
        }

        public AlertAction build() {
            return new AlertAction(this);
        }
    }
}

