/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.selenium.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.selenium.actions.FindElementAction;
import com.consol.citrus.selenium.config.xml.AbstractBrowserActionParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class FindElementActionParser
extends AbstractBrowserActionParser {
    @Override
    protected void parseAction(BeanDefinitionBuilder beanDefinition, Element element, ParserContext parserContext) {
        Element webElement = DomUtils.getChildElementByTagName((Element)element, (String)"element");
        if (webElement != null) {
            Element stylesContainerElement;
            String propertyValue = null;
            String property = null;
            if (webElement.hasAttribute("id")) {
                property = "id";
                propertyValue = webElement.getAttribute("id");
            } else if (webElement.hasAttribute("name")) {
                property = "name";
                propertyValue = webElement.getAttribute("name");
            } else if (webElement.hasAttribute("class-name")) {
                property = "class-name";
                propertyValue = webElement.getAttribute("class-name");
            } else if (webElement.hasAttribute("css-selector")) {
                property = "css-selector";
                propertyValue = webElement.getAttribute("css-selector");
            } else if (webElement.hasAttribute("link-text")) {
                property = "link-text";
                propertyValue = webElement.getAttribute("link-text");
            } else if (webElement.hasAttribute("xpath")) {
                property = "xpath";
                propertyValue = webElement.getAttribute("xpath");
            } else if (webElement.hasAttribute("tag-name")) {
                property = "tag-name";
                propertyValue = webElement.getAttribute("tag-name");
            }
            beanDefinition.addPropertyValue("property", (Object)property);
            beanDefinition.addPropertyValue("propertyValue", (Object)propertyValue);
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)webElement.getAttribute("tag-name"), (String)"tagName");
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)webElement.getAttribute("text"), (String)"text");
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)webElement.getAttribute("displayed"), (String)"displayed");
            BeanDefinitionParserUtils.setPropertyValue((BeanDefinitionBuilder)beanDefinition, (String)webElement.getAttribute("enabled"), (String)"enabled");
            Element attributesContainerElement = DomUtils.getChildElementByTagName((Element)webElement, (String)"attributes");
            if (attributesContainerElement != null) {
                HashMap<String, String> attributes = new HashMap<String, String>();
                List attributeElements = DomUtils.getChildElementsByTagName((Element)attributesContainerElement, (String)"attribute");
                for (Element attribute : attributeElements) {
                    attributes.put(attribute.getAttribute("name"), attribute.getAttribute("value"));
                }
                beanDefinition.addPropertyValue("attributes", attributes);
            }
            if ((stylesContainerElement = DomUtils.getChildElementByTagName((Element)webElement, (String)"styles")) != null) {
                HashMap<String, String> styles = new HashMap<String, String>();
                List styleElements = DomUtils.getChildElementsByTagName((Element)stylesContainerElement, (String)"style");
                for (Element style : styleElements) {
                    styles.put(style.getAttribute("name"), style.getAttribute("value"));
                }
                beanDefinition.addPropertyValue("styles", styles);
            }
        }
    }

    protected Class<? extends ElementActionFactoryBean<?, ?>> getBrowserActionClass() {
        return FindElementActionFactoryBean.class;
    }

    public static abstract class ElementActionFactoryBean<T extends FindElementAction, B extends FindElementAction.ElementActionBuilder<T, B>>
    extends AbstractBrowserActionParser.AbstractSeleniumActionFactoryBean<T, B> {
        protected String property;
        protected String propertyValue;

        public void setProperty(String property) {
            this.property = property;
        }

        public void setPropertyValue(String propertyValue) {
            this.propertyValue = propertyValue;
        }

        public void setTagName(String tagName) {
            ((FindElementAction.ElementActionBuilder)this.getBuilder()).tagName(tagName);
        }

        public void setBy(By by) {
            ((FindElementAction.ElementActionBuilder)this.getBuilder()).element(by);
        }

        public T getObject(B builder) throws Exception {
            ((FindElementAction.ElementActionBuilder)((Object)builder)).element(this.property, this.propertyValue);
            return (T)((FindElementAction)builder.build());
        }
    }

    public static final class FindElementActionFactoryBean
    extends ElementActionFactoryBean<FindElementAction, FindElementAction.Builder> {
        private final FindElementAction.Builder builder = new FindElementAction.Builder();

        public void setAttributes(Map<String, String> attributes) {
            attributes.forEach(this.builder::attribute);
        }

        public void setStyles(Map<String, String> styles) {
            styles.forEach(this.builder::style);
        }

        public void setDisplayed(boolean displayed) {
            this.builder.displayed(displayed);
        }

        public void setEnabled(boolean enabled) {
            this.builder.enabled(enabled);
        }

        public void setText(String text) {
            this.builder.text(text);
        }

        public FindElementAction getObject() throws Exception {
            return this.getObject(this.builder);
        }

        public Class<?> getObjectType() {
            return FindElementAction.class;
        }

        public FindElementAction.Builder getBuilder() {
            return this.builder;
        }
    }
}

