/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.config;

import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

public class SimulatorImportSelector
implements DeferredImportSelector,
EnvironmentAware {
    private static final String SIMULATOR_CONFIGURATION_CLASS_PROPERTY = "citrus.simulator.configuration.class";
    private static final String SIMULATOR_CONFIGURATION_CLASS_ENV = "CITRUS_SIMULATOR_CONFIGURATION_CLASS";
    private static final String SIMULATOR_CONFIGURATION_CLASS_DEFAULT = "com.consol.citrus.simulator.SimulatorConfig";
    private Environment env;

    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        String configurationClassName = this.env.getProperty(SIMULATOR_CONFIGURATION_CLASS_PROPERTY, this.env.getProperty(SIMULATOR_CONFIGURATION_CLASS_ENV, SIMULATOR_CONFIGURATION_CLASS_DEFAULT));
        if (ClassUtils.isPresent((String)configurationClassName, (ClassLoader)this.getClass().getClassLoader())) {
            return new String[]{configurationClassName};
        }
        return new String[0];
    }

    public void setEnvironment(Environment environment) {
        this.env = environment;
    }
}

