/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.controller;

import com.consol.citrus.simulator.model.ScenarioExecution;
import com.consol.citrus.simulator.service.ActivityService;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/activity"})
public class ActivityController {
    @Autowired
    private ActivityService activityService;

    @RequestMapping(method={RequestMethod.GET})
    public Collection<ScenarioExecution> getScenarioExecutions(@RequestParam(value="fromDate", required=false) Date fromDate, @RequestParam(value="toDate", required=false) Date toDate, @RequestParam(value="page", required=false) Integer page, @RequestParam(value="size", required=false) Integer size) {
        return this.activityService.getScenarioExecutionsByStartDate(fromDate, toDate, page, size);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public void clearExecutions() {
        this.activityService.clearScenarioExecutions();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/scenario/{name}"})
    public Collection<ScenarioExecution> getScenarioExecutionsByName(@PathVariable(value="name") String name) {
        return this.activityService.getScenarioExecutionsByName(name);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/status/{status}"})
    public Collection<ScenarioExecution> getScenarioExecutionsByStatus(@PathVariable(value="status") String status) {
        return this.activityService.getScenarioExecutionsByStatus(ScenarioExecution.Status.valueOf(status));
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public ScenarioExecution getScenarioExecution(@PathVariable(value="id") Long id) {
        return this.activityService.getScenarioExecutionById(id);
    }
}

