/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.controller;

import com.consol.citrus.simulator.model.Message;
import com.consol.citrus.simulator.model.MessageFilter;
import com.consol.citrus.simulator.service.MessageService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/message"})
public class MessageController {
    @Autowired
    private MessageService messageService;

    @RequestMapping(method={RequestMethod.POST})
    public Collection<Message> getMessages(@RequestBody MessageFilter filter) {
        return this.messageService.getMessagesMatchingFilter(filter);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    public void clearMessages() {
        this.messageService.clearMessages();
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    public Message getMessageById(@PathVariable(value="id") Long id) {
        return this.messageService.getMessageById(id);
    }
}

