/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.controller;

import com.consol.citrus.simulator.model.ScenarioParameter;
import com.consol.citrus.simulator.service.ScenarioExecutionService;
import com.consol.citrus.simulator.service.ScenarioLookupService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"api/scenario"})
public class ScenarioController {
    private final ScenarioExecutionService scenarioExecutionService;
    private final ScenarioLookupService scenarioLookupService;
    private final List<Scenario> scenarios;

    public ScenarioController(ScenarioExecutionService scenarioExecutionService, ScenarioLookupService scenarioLookupService) {
        this.scenarioExecutionService = scenarioExecutionService;
        this.scenarioLookupService = scenarioLookupService;
        this.scenarios = ScenarioController.getScenarioList(scenarioLookupService);
    }

    private static List<Scenario> getScenarioList(ScenarioLookupService scenarioLookupService) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        scenarioLookupService.getScenarioNames().forEach(name -> scenarios.add(new Scenario((String)name, Scenario.ScenarioType.MESSAGE_TRIGGERED)));
        scenarioLookupService.getStarterNames().forEach(name -> scenarios.add(new Scenario((String)name, Scenario.ScenarioType.STARTER)));
        return scenarios;
    }

    @RequestMapping(method={RequestMethod.POST})
    public Collection<Scenario> getScenarioNames(@RequestBody(required=false) ScenarioFilter filter) {
        return this.scenarios.stream().filter(scenario -> {
            if (filter != null && StringUtils.hasText((String)filter.getName())) {
                return scenario.getName().contains(filter.getName());
            }
            return true;
        }).sorted(Comparator.comparing(Scenario::getName)).collect(Collectors.toList());
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/parameters/{name}"})
    public Collection<ScenarioParameter> getScenarioParameters(@PathVariable(value="name") String scenarioName) {
        return this.scenarioLookupService.lookupScenarioParameters(scenarioName);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/launch/{name}"})
    public Long launchScenario(@PathVariable(value="name") String name, @RequestBody(required=false) List<ScenarioParameter> scenarioParameters) {
        return this.scenarioExecutionService.run(name, scenarioParameters);
    }

    public static class ScenarioFilter {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScenarioFilter)) {
                return false;
            }
            ScenarioFilter other = (ScenarioFilter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ScenarioFilter;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ScenarioController.ScenarioFilter(name=" + this.getName() + ")";
        }
    }

    public static class Scenario {
        private final String name;
        private final ScenarioType type;

        public Scenario(String name, ScenarioType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public ScenarioType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Scenario)) {
                return false;
            }
            Scenario other = (Scenario)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            ScenarioType this$type = this.getType();
            ScenarioType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Scenario;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            ScenarioType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "ScenarioController.Scenario(name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ")";
        }

        public static enum ScenarioType {
            STARTER,
            MESSAGE_TRIGGERED;

        }
    }
}

