/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.correlation;

import com.consol.citrus.TestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.simulator.correlation.CorrelationHandler;
import com.consol.citrus.simulator.correlation.HeaderMappingCorrelationHandler;
import com.consol.citrus.simulator.correlation.MessageTypeCorrelationHandler;
import com.consol.citrus.simulator.correlation.StartCorrelationHandlerAction;
import com.consol.citrus.simulator.correlation.StopCorrelationHandlerAction;
import com.consol.citrus.simulator.correlation.XPathPayloadCorrelationHandler;
import com.consol.citrus.simulator.scenario.ScenarioEndpoint;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class CorrelationHandlerBuilder
extends AbstractTestActionBuilder<StartCorrelationHandlerAction> {
    private static Logger log = LoggerFactory.getLogger(CorrelationHandlerBuilder.class);
    private final StopCorrelationHandlerAction stopCorrelationAction = new StopCorrelationHandlerAction();
    private final ApplicationContext applicationContext;
    private ScenarioEndpoint scenarioEndpoint;

    public CorrelationHandlerBuilder(ScenarioEndpoint scenarioEndpoint, ApplicationContext applicationContext) {
        super((TestAction)new StartCorrelationHandlerAction());
        this.scenarioEndpoint = scenarioEndpoint;
        this.applicationContext = applicationContext;
    }

    public CorrelationHandlerBuilder onHeader(String headerName, String value) {
        return this.withHandler(new HeaderMappingCorrelationHandler(this.scenarioEndpoint, headerName, value));
    }

    public CorrelationHandlerBuilder onMessageType(String type) {
        return this.withHandler(new MessageTypeCorrelationHandler(this.scenarioEndpoint, type));
    }

    public CorrelationHandlerBuilder onPayload(String expression, String value) {
        return this.withHandler(new XPathPayloadCorrelationHandler(this.lookupNamespaceContextBuilder(), this.scenarioEndpoint, expression, value));
    }

    public CorrelationHandlerBuilder withHandler(CorrelationHandler handler) {
        ((StartCorrelationHandlerAction)this.action).setCorrelationHandler(handler);
        this.stopCorrelationAction.setCorrelationHandler(handler);
        return this;
    }

    public TestAction stop() {
        return this.stopCorrelationAction;
    }

    private NamespaceContextBuilder lookupNamespaceContextBuilder() {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, NamespaceContextBuilder.class);
        if (beanNames.length > 0) {
            if (beanNames.length > 1) {
                log.warn("Expected to find 1 beans of type {} but found instead {} ({})", new Object[]{beanNames.length, NamespaceContextBuilder.class.getCanonicalName(), beanNames});
            }
            log.debug("Using NamespaceContextBuilder - {}", (Object)beanNames[0]);
            return (NamespaceContextBuilder)this.applicationContext.getBean(beanNames[0], NamespaceContextBuilder.class);
        }
        log.debug("Using NamespaceContextBuilder - default");
        return new NamespaceContextBuilder();
    }
}

