/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.correlation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.adapter.mapping.XPathPayloadMappingKeyExtractor;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.correlation.AbstractCorrelationHandler;
import com.consol.citrus.simulator.scenario.ScenarioEndpoint;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathPayloadCorrelationHandler
extends AbstractCorrelationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(XPathPayloadCorrelationHandler.class);
    private XPathPayloadMappingKeyExtractor xPathPayloadMappingKeyExtractor = new XPathPayloadMappingKeyExtractor();
    private final String value;

    public XPathPayloadCorrelationHandler(NamespaceContextBuilder namespaceContextBuilder, ScenarioEndpoint scenarioEndpoint, String expression, String value) {
        super(scenarioEndpoint);
        this.xPathPayloadMappingKeyExtractor.setNamespaceContextBuilder(namespaceContextBuilder);
        this.xPathPayloadMappingKeyExtractor.setXpathExpression(expression);
        this.value = value;
    }

    @Override
    public boolean isHandlerFor(Message message, TestContext context) {
        boolean isIntermediateMessage;
        try {
            isIntermediateMessage = this.xPathPayloadMappingKeyExtractor.extractMappingKey(message).equals(context.replaceDynamicContentInString(this.value));
        }
        catch (RuntimeException e) {
            LOG.debug("Error checking whether message({}) is an intermediate message: {}", (Object)message.getId(), (Object)e.getMessage());
            isIntermediateMessage = false;
        }
        LOG.debug("Intermediate message({}): {}", (Object)message.getId(), (Object)isIntermediateMessage);
        return isIntermediateMessage;
    }
}

