/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.endpoint.EndpointMessageHandler;
import java.util.Arrays;
import java.util.Optional;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Component;

@Component
public class EndpointProducerInterceptor
implements MethodInterceptor {
    private final EndpointMessageHandler endpointMessageHandler;

    public EndpointProducerInterceptor(EndpointMessageHandler endpointMessageHandler) {
        this.endpointMessageHandler = endpointMessageHandler;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result = methodInvocation.proceed();
        if (this.isSendMethod(methodInvocation)) {
            Optional<TestContext> testContext = this.getArgument(methodInvocation, TestContext.class);
            Optional<Message> message = this.getArgument(methodInvocation, Message.class);
            if (testContext.isPresent() && message.isPresent()) {
                this.endpointMessageHandler.handleSentMessage(message.get(), testContext.get());
            }
        }
        return result;
    }

    private boolean isSendMethod(MethodInvocation methodInvocation) {
        return "send".equals(methodInvocation.getMethod().getName());
    }

    private <T> Optional<T> getArgument(MethodInvocation methodInvocation, Class<T> clazz) {
        Object[] arguments = methodInvocation.getArguments();
        if (arguments != null) {
            return Arrays.stream(arguments).filter(clazz::isInstance).map(clazz::cast).findFirst();
        }
        return Optional.empty();
    }
}

