/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.http.message.HttpMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public class HttpRequestAnnotationMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequestAnnotationMatcher.class);
    private PathMatcher pathMatcher = new AntPathMatcher();

    private HttpRequestAnnotationMatcher() {
    }

    public static HttpRequestAnnotationMatcher instance() {
        return new HttpRequestAnnotationMatcher();
    }

    public boolean checkRequestPathSupported(HttpMessage request, RequestMapping requestMapping, boolean exactMatch) {
        String requestPath = Optional.ofNullable(request.getPath()).orElse("");
        String[] supportedRequestPaths = requestMapping.value();
        if (supportedRequestPaths.length > 0) {
            for (String supportedRequestPath : supportedRequestPaths) {
                if (!(exactMatch ? supportedRequestPath.equals(requestPath) : this.pathMatcher.match(supportedRequestPath, requestPath))) continue;
                LOG.debug("Request path {} supported. Path found in the list of supported request paths: {}", (Object)requestPath, (Object)supportedRequestPaths);
                return true;
            }
            LOG.debug("Request path {} not supported. Path not found in the list of supported request paths: {}", (Object)requestPath, (Object)supportedRequestPaths);
            return false;
        }
        LOG.debug("Request path {} supported. All request paths are supported", (Object)requestPath);
        return true;
    }

    public boolean checkRequestMethodSupported(HttpMessage request, RequestMapping requestMapping) {
        String actualRequestMethod;
        RequestMethod[] requestMethods = requestMapping.method();
        String string = actualRequestMethod = request.getRequestMethod() != null ? request.getRequestMethod().name() : HttpMethod.POST.name();
        if (requestMethods.length > 0) {
            for (RequestMethod method : requestMethods) {
                if (!method.name().equals(actualRequestMethod)) continue;
                LOG.debug("Request method {} supported. Found in the list of supported request methods: {}", (Object)actualRequestMethod, (Object)requestMethods);
                return true;
            }
            LOG.debug("Request method {} not supported. No contained in the list of supported request methods: {}", (Object)actualRequestMethod, (Object)requestMethods);
            return false;
        }
        LOG.debug("Request method {} supported. All request methods are supported", (Object)actualRequestMethod);
        return true;
    }

    public boolean checkRequestQueryParamsSupported(HttpMessage request, RequestMapping requestMapping) {
        List<String> annotatedQueryParams = this.getAnnotatedQueryParams(requestMapping);
        List<String> requestQueryParams = this.getRequestQueryParams(request);
        List<String> invalidQueryParams = this.getInvalidQueryParams(requestQueryParams, annotatedQueryParams);
        if (!invalidQueryParams.isEmpty()) {
            LOG.debug("Request query parameters '{}' do not match the supported query parameters: {} (invalid: {})", new Object[]{requestQueryParams, annotatedQueryParams, invalidQueryParams});
        } else {
            LOG.debug("Request query parameters '{}' match the supported query parameters: {}", requestQueryParams, annotatedQueryParams);
        }
        return invalidQueryParams.isEmpty();
    }

    private List<String> getInvalidQueryParams(List<String> requestQueryParams, List<String> annotatedQueryParams) {
        List<String> requestQueryParamKeys = this.getQueryParamKeys(requestQueryParams);
        ArrayList<String> invalidRequestQueryParamKeys = new ArrayList<String>();
        String cannotContainKeyPrefix = "!";
        invalidRequestQueryParamKeys.addAll(annotatedQueryParams.stream().filter(k -> !k.startsWith("!")).filter(k -> !requestQueryParamKeys.contains(k)).map(k -> String.format("Expected but missing: %s", k)).collect(Collectors.toList()));
        invalidRequestQueryParamKeys.addAll(annotatedQueryParams.stream().filter(k -> k.startsWith("!")).filter(k -> requestQueryParamKeys.contains(k.substring("!".length()))).map(k -> String.format("Unexpected but present: %s", k.substring("!".length()))).collect(Collectors.toList()));
        return invalidRequestQueryParamKeys;
    }

    private List<String> getAnnotatedQueryParams(RequestMapping requestMapping) {
        ArrayList<String> annotatedQueryParams = new ArrayList<String>();
        if (requestMapping != null) {
            annotatedQueryParams.addAll(Arrays.asList(requestMapping.params()));
        }
        return annotatedQueryParams;
    }

    private List<String> getRequestQueryParams(HttpMessage request) {
        return request.getQueryParams().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList());
    }

    private List<String> getQueryParamKeys(List<String> queryParams) {
        return queryParams.stream().map(this::getQueryParamKeyValue).filter(strings -> ((String[])strings).length > 0).map(strings -> strings[0]).collect(Collectors.toList());
    }

    private String[] getQueryParamKeyValue(String queryParam) {
        if (queryParam.contains("=")) {
            return StringUtils.tokenizeToStringArray((String)queryParam, (String)"=");
        }
        return new String[]{"", ""};
    }
}

