/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.http.HttpRequestAnnotationMatcher;
import com.consol.citrus.simulator.scenario.Scenario;
import com.consol.citrus.simulator.scenario.ScenarioListAware;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.scenario.mapper.AbstractScenarioMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class HttpRequestAnnotationScenarioMapper
extends AbstractScenarioMapper
implements ScenarioListAware {
    @Autowired(required=false)
    private List<SimulatorScenario> scenarioList = new ArrayList<SimulatorScenario>();
    private HttpRequestAnnotationMatcher httpRequestAnnotationMatcher = HttpRequestAnnotationMatcher.instance();

    @Override
    protected String getMappingKey(Message request) {
        if (request instanceof HttpMessage) {
            return this.getMappingKeyForHttpMessage((HttpMessage)request);
        }
        return super.getMappingKey(request);
    }

    protected String getMappingKeyForHttpMessage(HttpMessage httpMessage) {
        Optional<String> mapping = this.scenarioList.stream().map(scenario -> EnrichedScenarioWithRequestMapping.builder().scenario((SimulatorScenario)scenario).requestMapping((RequestMapping)AnnotationUtils.findAnnotation(scenario.getClass(), RequestMapping.class)).build()).filter(EnrichedScenarioWithRequestMapping::hasRequestMapping).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestPathSupported(httpMessage, swrm.getRequestMapping(), true)).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestMethodSupported(httpMessage, swrm.getRequestMapping())).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestQueryParamsSupported(httpMessage, swrm.getRequestMapping())).map(EnrichedScenarioWithRequestMapping::name).findFirst();
        if (!mapping.isPresent()) {
            mapping = this.scenarioList.stream().map(scenario -> EnrichedScenarioWithRequestMapping.builder().scenario((SimulatorScenario)scenario).requestMapping((RequestMapping)AnnotationUtils.findAnnotation(scenario.getClass(), RequestMapping.class)).build()).filter(EnrichedScenarioWithRequestMapping::hasRequestMapping).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestPathSupported(httpMessage, swrm.getRequestMapping(), false)).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestMethodSupported(httpMessage, swrm.getRequestMapping())).filter(swrm -> this.httpRequestAnnotationMatcher.checkRequestQueryParamsSupported(httpMessage, swrm.getRequestMapping())).map(EnrichedScenarioWithRequestMapping::name).findFirst();
        }
        return mapping.orElseGet(() -> super.getMappingKey((Message)httpMessage));
    }

    public List<SimulatorScenario> getScenarios() {
        return this.scenarioList;
    }

    public void setScenarios(List<SimulatorScenario> scenarios) {
        this.scenarioList = scenarios;
    }

    @Override
    public void setScenarioList(List<SimulatorScenario> scenarioList) {
        this.scenarioList = scenarioList;
    }

    public SimulatorConfigurationProperties getConfiguration() {
        return super.getSimulatorConfigurationProperties();
    }

    public void setConfiguration(SimulatorConfigurationProperties configuration) {
        this.setSimulatorConfigurationProperties(configuration);
    }

    private static final class EnrichedScenarioWithRequestMapping {
        final SimulatorScenario scenario;
        final RequestMapping requestMapping;

        public boolean hasRequestMapping() {
            return this.requestMapping != null;
        }

        public String name() {
            return this.scenario.getClass().getAnnotation(Scenario.class).value();
        }

        EnrichedScenarioWithRequestMapping(SimulatorScenario scenario, RequestMapping requestMapping) {
            this.scenario = scenario;
            this.requestMapping = requestMapping;
        }

        public static EnrichedScenarioWithRequestMappingBuilder builder() {
            return new EnrichedScenarioWithRequestMappingBuilder();
        }

        public SimulatorScenario getScenario() {
            return this.scenario;
        }

        public RequestMapping getRequestMapping() {
            return this.requestMapping;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnrichedScenarioWithRequestMapping)) {
                return false;
            }
            EnrichedScenarioWithRequestMapping other = (EnrichedScenarioWithRequestMapping)o;
            SimulatorScenario this$scenario = this.getScenario();
            SimulatorScenario other$scenario = other.getScenario();
            if (this$scenario == null ? other$scenario != null : !this$scenario.equals(other$scenario)) {
                return false;
            }
            RequestMapping this$requestMapping = this.getRequestMapping();
            RequestMapping other$requestMapping = other.getRequestMapping();
            return !(this$requestMapping == null ? other$requestMapping != null : !this$requestMapping.equals(other$requestMapping));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SimulatorScenario $scenario = this.getScenario();
            result = result * 59 + ($scenario == null ? 43 : $scenario.hashCode());
            RequestMapping $requestMapping = this.getRequestMapping();
            result = result * 59 + ($requestMapping == null ? 43 : $requestMapping.hashCode());
            return result;
        }

        public String toString() {
            return "HttpRequestAnnotationScenarioMapper.EnrichedScenarioWithRequestMapping(scenario=" + this.getScenario() + ", requestMapping=" + this.getRequestMapping() + ")";
        }

        public static class EnrichedScenarioWithRequestMappingBuilder {
            private SimulatorScenario scenario;
            private RequestMapping requestMapping;

            EnrichedScenarioWithRequestMappingBuilder() {
            }

            public EnrichedScenarioWithRequestMappingBuilder scenario(SimulatorScenario scenario) {
                this.scenario = scenario;
                return this;
            }

            public EnrichedScenarioWithRequestMappingBuilder requestMapping(RequestMapping requestMapping) {
                this.requestMapping = requestMapping;
                return this;
            }

            public EnrichedScenarioWithRequestMapping build() {
                return new EnrichedScenarioWithRequestMapping(this.scenario, this.requestMapping);
            }

            public String toString() {
                return "HttpRequestAnnotationScenarioMapper.EnrichedScenarioWithRequestMapping.EnrichedScenarioWithRequestMappingBuilder(scenario=" + this.scenario + ", requestMapping=" + this.requestMapping + ")";
            }
        }
    }
}

