/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.simulator.config.SimulatorConfigurationProperties;
import com.consol.citrus.simulator.http.HttpOperationScenario;
import com.consol.citrus.simulator.scenario.ScenarioListAware;
import com.consol.citrus.simulator.scenario.SimulatorScenario;
import com.consol.citrus.simulator.scenario.mapper.AbstractScenarioMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

public class HttpRequestPathScenarioMapper
extends AbstractScenarioMapper
implements ScenarioListAware {
    @Autowired(required=false)
    private List<HttpOperationScenario> scenarioList = new ArrayList<HttpOperationScenario>();
    private PathMatcher pathMatcher = new AntPathMatcher();

    @Override
    protected String getMappingKey(Message request) {
        String requestPath;
        if (request instanceof HttpMessage && (requestPath = ((HttpMessage)request).getPath()) != null) {
            for (HttpOperationScenario scenario : this.scenarioList) {
                if (!scenario.getPath().equals(requestPath) || !scenario.getMethod().name().equals(((HttpMessage)request).getRequestMethod().name())) continue;
                return scenario.getOperation().getOperationId();
            }
            for (HttpOperationScenario scenario : this.scenarioList) {
                if (!this.pathMatcher.match(scenario.getPath(), requestPath) || !scenario.getMethod().name().equals(((HttpMessage)request).getRequestMethod().name())) continue;
                return scenario.getOperation().getOperationId();
            }
        }
        return super.getMappingKey(request);
    }

    public List<HttpOperationScenario> getHttpScenarios() {
        return this.scenarioList;
    }

    public void setHttpScenarios(List<HttpOperationScenario> httpScenarios) {
        this.scenarioList = httpScenarios;
    }

    @Override
    public void setScenarioList(List<SimulatorScenario> scenarioList) {
        this.scenarioList = scenarioList.stream().filter(scenario -> scenario instanceof HttpOperationScenario).map(scenario -> (HttpOperationScenario)scenario).collect(Collectors.toList());
    }

    public void setConfiguration(SimulatorConfigurationProperties configuration) {
        this.setSimulatorConfigurationProperties(configuration);
    }
}

