/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.http.controller.HttpMessageController;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.TypeConversionUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class InterceptorHttp
implements HandlerInterceptor {
    private final MessageListeners messageListeners;

    public InterceptorHttp(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.messageListeners != null) {
            this.messageListeners.onInboundMessage((Message)new RawMessage(this.getRequestContent(request)), null);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (this.messageListeners != null) {
            this.messageListeners.onOutboundMessage((Message)new RawMessage(this.getResponseContent(response, handler)), null);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }

    private String getRequestContent(HttpServletRequest request) throws IOException {
        return FileUtils.readToString((InputStream)request.getInputStream());
    }

    private String getResponseContent(HttpServletResponse response, Object handler) {
        HttpMessageController handlerController;
        ResponseEntity responseEntity;
        if (handler instanceof HttpMessageController && (responseEntity = (handlerController = (HttpMessageController)handler).getResponseCache()) != null) {
            return (String)TypeConversionUtils.convertIfNecessary((Object)responseEntity.getBody(), String.class);
        }
        return "Could not extract Http Response";
    }
}

