/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.simulator.http;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.http.controller.HttpMessageController;
import com.consol.citrus.http.interceptor.LoggingHandlerInterceptor;
import com.consol.citrus.http.message.DelegatingHttpEntityMessageConverter;
import com.consol.citrus.http.servlet.RequestCachingServletFilter;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.simulator.SimulatorAutoConfiguration;
import com.consol.citrus.simulator.endpoint.SimulatorEndpointAdapter;
import com.consol.citrus.simulator.http.HttpRequestAnnotationScenarioMapper;
import com.consol.citrus.simulator.http.HttpScenarioGenerator;
import com.consol.citrus.simulator.http.InterceptorHttp;
import com.consol.citrus.simulator.http.SimulatorHttpMessageConverter;
import com.consol.citrus.simulator.http.SimulatorRestConfigurationProperties;
import com.consol.citrus.simulator.http.SimulatorRestConfigurer;
import com.consol.citrus.simulator.listener.SimulatorMessageListener;
import com.consol.citrus.simulator.scenario.mapper.ScenarioMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.SimpleControllerHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@AutoConfigureAfter(value={SimulatorAutoConfiguration.class})
@EnableConfigurationProperties(value={SimulatorRestConfigurationProperties.class})
@ConditionalOnProperty(prefix="citrus.simulator.rest", value={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication
public class SimulatorRestAutoConfiguration {
    @Autowired(required=false)
    private SimulatorRestConfigurer configurer;
    @Autowired
    private MessageListeners messageListeners;
    @Autowired
    private SimulatorMessageListener simulatorMessageListener;
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    @Autowired
    private SimulatorRestConfigurationProperties simulatorRestConfiguration;
    private HttpMessageController restController;

    @Bean
    public FilterRegistrationBean<RequestCachingServletFilter> requestCachingFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new RequestCachingServletFilter(), new ServletRegistrationBean[0]);
        String urlMapping = this.getUrlMapping();
        if (urlMapping.endsWith("**")) {
            urlMapping = urlMapping.substring(0, urlMapping.length() - 1);
        }
        filterRegistrationBean.setUrlPatterns(Collections.singleton(urlMapping));
        return filterRegistrationBean;
    }

    @Bean
    public HandlerMapping simulatorRestHandlerMapping(ApplicationContext applicationContext) {
        SimpleUrlHandlerMapping handlerMapping = new SimpleUrlHandlerMapping();
        handlerMapping.setOrder(Integer.MIN_VALUE);
        handlerMapping.setAlwaysUseFullPath(true);
        HashMap<String, HttpMessageController> mappings = new HashMap<String, HttpMessageController>();
        mappings.put(this.getUrlMapping(), this.createRestController(applicationContext));
        handlerMapping.setUrlMap(mappings);
        handlerMapping.setInterceptors((Object[])this.interceptors());
        return handlerMapping;
    }

    @Bean
    public HandlerAdapter simulatorRestHandlerAdapter(final ApplicationContext applicationContext) {
        final RequestMappingHandlerMapping handlerMapping = new RequestMappingHandlerMapping(){

            protected void initHandlerMethods() {
                this.detectHandlerMethods(SimulatorRestAutoConfiguration.this.createRestController(applicationContext));
                super.initHandlerMethods();
            }

            protected boolean isHandler(Class<?> beanType) {
                return beanType.isAssignableFrom(HttpMessageController.class) && super.isHandler(beanType);
            }
        };
        handlerMapping.setApplicationContext(applicationContext);
        handlerMapping.afterPropertiesSet();
        this.requestMappingHandlerAdapter.getMessageConverters().add(0, new SimulatorHttpMessageConverter());
        this.requestMappingHandlerAdapter.getMessageConverters().add(new DelegatingHttpEntityMessageConverter());
        this.requestMappingHandlerAdapter.setCacheSeconds(0);
        return new SimpleControllerHandlerAdapter(){

            public boolean supports(Object handler) {
                return handler instanceof HttpMessageController;
            }

            public ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
                return SimulatorRestAutoConfiguration.this.requestMappingHandlerAdapter.handle(request, response, handlerMapping.getHandler(request).getHandler());
            }
        };
    }

    @Bean
    public SimulatorEndpointAdapter simulatorRestEndpointAdapter() {
        return new SimulatorEndpointAdapter();
    }

    @Bean
    public EndpointAdapter simulatorRestFallbackEndpointAdapter() {
        if (this.configurer != null) {
            return this.configurer.fallbackEndpointAdapter();
        }
        return new EmptyResponseEndpointAdapter();
    }

    protected HttpMessageController createRestController(ApplicationContext applicationContext) {
        if (this.restController == null) {
            this.restController = new HttpMessageController();
            SimulatorEndpointAdapter endpointAdapter = this.simulatorRestEndpointAdapter();
            endpointAdapter.setApplicationContext(applicationContext);
            endpointAdapter.setMappingKeyExtractor(this.simulatorRestScenarioMapper());
            endpointAdapter.setFallbackEndpointAdapter(this.simulatorRestFallbackEndpointAdapter());
            this.restController.setEndpointAdapter((EndpointAdapter)endpointAdapter);
        }
        return this.restController;
    }

    @Bean
    public ScenarioMapper simulatorRestScenarioMapper() {
        if (this.configurer != null) {
            return this.configurer.scenarioMapper();
        }
        return new HttpRequestAnnotationScenarioMapper();
    }

    @Bean
    protected HandlerInterceptor httpInterceptor() {
        this.messageListeners.addMessageListener((MessageListener)this.simulatorMessageListener);
        return new InterceptorHttp(this.messageListeners);
    }

    @Bean
    @ConditionalOnMissingBean(value={HttpScenarioGenerator.class})
    @ConditionalOnProperty(prefix="citrus.simulator.rest.swagger", value={"enabled"}, havingValue="true")
    public static HttpScenarioGenerator simulatorRestScenarioGenerator(Environment environment) {
        return new HttpScenarioGenerator(environment);
    }

    protected String getUrlMapping() {
        if (this.configurer != null) {
            return this.configurer.urlMapping(this.simulatorRestConfiguration);
        }
        return this.simulatorRestConfiguration.getUrlMapping();
    }

    protected HandlerInterceptor[] interceptors() {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (this.configurer != null) {
            Collections.addAll(interceptors, this.configurer.interceptors());
        }
        interceptors.add(new LoggingHandlerInterceptor());
        interceptors.add(this.httpInterceptor());
        return interceptors.toArray(new HandlerInterceptor[interceptors.size()]);
    }
}

